/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public abstract class FunctionDefinitionBuilder {
    private final String virtualColumn;
    private final String type;
    protected final List<String> columns;
    protected final String argsList;

    public FunctionDefinitionBuilder(String virtualColumn, String type, List<String> columns, @Nullable String argsList) {
        this.virtualColumn = virtualColumn;
        this.type = type;
        this.columns = columns;
        this.argsList = argsList;
    }

    @Nullable
    public String getVirtualColumn(DatabaseType dbType) {
        if (!this.supportsFunctionBasedIndices(dbType)) {
            return this.virtualColumn;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public abstract String getFunctionDefinition(DatabaseType var1);

    public boolean supportsFunctionBasedIndices(DatabaseType dbType) {
        return DatabaseTypeFactory.ORACLE_10G == dbType || DatabaseTypeFactory.ORACLE_8I == dbType || DatabaseTypeFactory.POSTGRES == dbType || DatabaseTypeFactory.POSTGRES_7_2 == dbType || DatabaseTypeFactory.POSTGRES_7_3 == dbType;
    }
}

