/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractDatabaseType;

abstract class AbstractHsqlDatabaseType
extends AbstractDatabaseType {
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int MICRO = 2;

    AbstractHsqlDatabaseType(String name) {
        super(name, "hsql", new String[]{"HSQL Database Engine"});
    }

    private int[] parseVersionStr(String version) {
        int[] versionNumber = new int[]{0, 0, 0};
        StringTokenizer versionTokens = new StringTokenizer(version, ".");
        if (versionTokens.hasMoreElements()) {
            versionNumber[0] = Integer.parseInt(versionTokens.nextToken());
            if (versionTokens.hasMoreElements()) {
                versionNumber[1] = Integer.parseInt(versionTokens.nextToken());
                if (versionTokens.hasMoreElements()) {
                    versionNumber[2] = Integer.parseInt(versionTokens.nextToken());
                }
            }
        }
        return versionNumber;
    }

    private int[] getHsqlVersion(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        return this.parseVersionStr(metaData.getDatabaseProductVersion());
    }

    boolean hsqlVersionGreaterThanOrEqual(Connection con, int major, int minor, int micro) throws SQLException {
        int[] vers = this.getHsqlVersion(con);
        return AbstractHsqlDatabaseType.versionGreaterThanOrEqual(vers[0], vers[1], major, minor) && (major != vers[0] || minor != vers[1] || vers[2] >= micro);
    }

    boolean hsqlVersionLessThanOrEqual(Connection con, int major, int minor, int micro) throws SQLException {
        int[] vers = this.getHsqlVersion(con);
        return AbstractHsqlDatabaseType.versionGreaterThanOrEqual(major, minor, vers[0], vers[1]) && (major != vers[0] || minor != vers[1] || vers[2] <= micro);
    }

    @Override
    protected String getChangeColumnTypeStructure() {
        return "ALTER TABLE {0} MODIFY {1} {2}";
    }

    @Override
    public String getDropIndexStructure() {
        return "DROP INDEX {schemaName_with_dot}{indexName}";
    }
}

