/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;

public class SerializationUtil {
    private SerializationUtil() {
        throw new Error("static-only");
    }

    @Nullable
    public static byte[] serialize(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        try {
            try (ObjectOutputStream out = new ObjectOutputStream(os);){
                out.writeObject(obj);
            }
            return os.toByteArray();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Trying to persist an object that can't be serialized", ioe);
        }
    }

    @Nullable
    public static Object deserialize(@Nullable byte[] binaryInput) {
        return binaryInput != null ? SerializationUtil.deserialize(new ByteArrayInputStream(binaryInput)) : null;
    }

    @Nullable
    public static Object deserialize(@Nullable InputStream binaryInput) {
        Object object;
        if (null == binaryInput) {
            return null;
        }
        ObjectInputStream in = new ObjectInputStream(binaryInput);
        try {
            object = in.readObject();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to read in persisted object", ex);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable to load class for persisted object", ex);
            }
        }
        in.close();
        return object;
    }

    @Nullable
    public static String encodeBase64(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] encoded = Base64.encodeBase64((byte[])bytes, (boolean)true);
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }
}

