/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.ofbiz.core.entity.jdbc.interceptors.NoopSQLInterceptorFactory;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptorFactory;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SafeDelegatingSqlConnectionInterceptor;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.Debug;

public class SQLInterceptorSupport {
    public static final String INTERCEPTOR_FACTORY_CLASS_NAME_KEY = "sqlinterceptor.factory.class";
    private static final Properties CONFIGURATION = new Properties();
    private static final SQLInterceptorFactory interceptorFactory;

    public static SQLInterceptor getNonNullSQLInterceptor(String ofbizHelperName) {
        if (interceptorFactory == null) {
            throw new IllegalStateException("How can this happen? interceptorFactory must be non null by design");
        }
        SQLInterceptor sqlInterceptor = interceptorFactory.newSQLInterceptor(ofbizHelperName);
        if (sqlInterceptor == null) {
            sqlInterceptor = NoopSQLInterceptorFactory.NOOP_INTERCEPTOR;
        }
        return sqlInterceptor;
    }

    public static SQLConnectionInterceptor getNonNullSQLConnectionInterceptor(String ofbizHelperName) {
        return new SafeDelegatingSqlConnectionInterceptor(SQLInterceptorSupport.getNonNullDelegate(ofbizHelperName));
    }

    private static SQLConnectionInterceptor getNonNullDelegate(String ofbizHelperName) {
        SQLInterceptor sqlInterceptor = SQLInterceptorSupport.getNonNullSQLInterceptor(ofbizHelperName);
        if (sqlInterceptor instanceof SQLConnectionInterceptor) {
            return (SQLConnectionInterceptor)sqlInterceptor;
        }
        return new DelegatingNoOpSQLConnectionInterceptor(sqlInterceptor);
    }

    private static SQLInterceptorFactory loadInterceptorFactoryClass() {
        SQLInterceptorFactory interceptorFactory = NoopSQLInterceptorFactory.NOOP_INTERCEPTOR_FACTORY;
        String className = CONFIGURATION.getProperty(INTERCEPTOR_FACTORY_CLASS_NAME_KEY);
        if (className != null) {
            try {
                Class<?> interceptorFactoryClass = ClassLoaderUtils.loadClass(className, SQLInterceptorSupport.class);
                if (SQLInterceptorFactory.class.isAssignableFrom(interceptorFactoryClass)) {
                    interceptorFactory = (SQLInterceptorFactory)interceptorFactoryClass.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Debug.logError((Throwable)e, (String)("Unable to load SQLInterceptorFactory class. " + className));
            }
        }
        return interceptorFactory;
    }

    static {
        try {
            CONFIGURATION.load(ClassLoaderUtils.getResourceAsStream("ofbiz-database.properties", SQLInterceptorSupport.class));
        }
        catch (Exception e) {
            Debug.logError((String)"Unable to find ofbiz-database.properties file. Using default values for ofbiz configuration.");
        }
        interceptorFactory = SQLInterceptorSupport.loadInterceptorFactoryClass();
    }

    private static class DelegatingNoOpSQLConnectionInterceptor
    implements SQLConnectionInterceptor {
        private final SQLInterceptor sqlInterceptor;

        public DelegatingNoOpSQLConnectionInterceptor(SQLInterceptor delegate) {
            this.sqlInterceptor = delegate;
        }

        @Override
        public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        }

        @Override
        public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        }

        @Override
        public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
            this.sqlInterceptor.beforeExecution(sqlString, parameterValues, statement);
        }

        @Override
        public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
            this.sqlInterceptor.afterSuccessfulExecution(sqlString, parameterValues, statement, resultSet, rowsUpdated);
        }

        @Override
        public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
            this.sqlInterceptor.onException(sqlString, parameterValues, statement, sqlException);
        }
    }
}

