/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.GenericDAO;
import org.ofbiz.core.entity.GenericDataSourceException;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericNotImplementedException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.jdbc.SQLProcessor;
import org.ofbiz.core.entity.jdbc.SerializationUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilValidate;

public class SqlJdbcUtil {
    public static final String module = GenericDAO.class.getName();
    private static final Map<String, FieldType> JAVA_TYPE_MAP = FieldType.buildJavaTypeMap();

    public static boolean isBoolean(String fieldType) {
        return FieldType.BOOLEAN.matches(fieldType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String makeFromClause(ModelEntity modelEntity, DatasourceInfo datasourceInfo) throws GenericEntityException {
        StringBuilder sql = new StringBuilder(" FROM ");
        if (modelEntity instanceof ModelViewEntity) {
            ModelViewEntity modelViewEntity = (ModelViewEntity)modelEntity;
            if ("ansi".equals(datasourceInfo.getJoinStyle())) {
                boolean fromEmpty;
                TreeSet<String> joinedAliasSet = new TreeSet<String>();
                StringBuilder openParens = new StringBuilder();
                StringBuilder restOfStatement = new StringBuilder();
                for (int i = 0; i < modelViewEntity.getViewLinksSize(); ++i) {
                    if (i > 0) {
                        openParens.append('(');
                    }
                    ModelViewEntity.ModelViewLink viewLink = modelViewEntity.getViewLink(i);
                    ModelEntity linkEntity = modelViewEntity.getMemberModelEntity(viewLink.getEntityAlias());
                    ModelEntity relLinkEntity = modelViewEntity.getMemberModelEntity(viewLink.getRelEntityAlias());
                    if (i == 0) {
                        restOfStatement.append(SqlJdbcUtil.makeViewTable(linkEntity, datasourceInfo));
                        restOfStatement.append(' ');
                        restOfStatement.append(viewLink.getEntityAlias());
                        joinedAliasSet.add(viewLink.getEntityAlias());
                    } else if (!joinedAliasSet.contains(viewLink.getEntityAlias())) {
                        throw new GenericModelException("Tried to link the " + viewLink.getEntityAlias() + " alias to the " + viewLink.getRelEntityAlias() + " alias of the " + modelViewEntity.getEntityName() + " view-entity, but it is not the first view-link and has not been included in a previous view-link. In other words, the left/main alias isn't connected to the rest of the member-entities yet.");
                    }
                    joinedAliasSet.add(viewLink.getRelEntityAlias());
                    if (viewLink.isRelOptional()) {
                        restOfStatement.append(" LEFT JOIN ");
                    } else {
                        restOfStatement.append(" INNER JOIN ");
                    }
                    restOfStatement.append(SqlJdbcUtil.makeViewTable(relLinkEntity, datasourceInfo));
                    restOfStatement.append(' ');
                    restOfStatement.append(viewLink.getRelEntityAlias());
                    restOfStatement.append(" ON ");
                    StringBuilder condBuffer = new StringBuilder();
                    for (int j = 0; j < viewLink.getKeyMapsSize(); ++j) {
                        ModelKeyMap keyMap = viewLink.getKeyMap(j);
                        String constValue = keyMap.getConstValue();
                        ModelField linkField = linkEntity.getField(keyMap.getFieldName());
                        String aliasToUse = viewLink.getEntityAlias();
                        if (constValue.length() > 0 && linkField == null) {
                            linkField = relLinkEntity.getField(keyMap.getRelFieldName());
                            aliasToUse = viewLink.getRelEntityAlias();
                        }
                        if (condBuffer.length() > 0) {
                            condBuffer.append(" AND ");
                        }
                        condBuffer.append(aliasToUse);
                        condBuffer.append('.');
                        condBuffer.append(SqlJdbcUtil.filterColName(linkField.getColName()));
                        condBuffer.append(" = ");
                        if (constValue.length() > 0) {
                            condBuffer.append('\'');
                            condBuffer.append(constValue);
                            condBuffer.append('\'');
                            continue;
                        }
                        ModelField relLinkField = relLinkEntity.getField(keyMap.getRelFieldName());
                        condBuffer.append(viewLink.getRelEntityAlias());
                        condBuffer.append('.');
                        condBuffer.append(SqlJdbcUtil.filterColName(relLinkField.getColName()));
                    }
                    if (condBuffer.length() == 0) {
                        throw new GenericModelException("No view-link/join key-maps found for the " + viewLink.getEntityAlias() + " and the " + viewLink.getRelEntityAlias() + " member-entities of the " + modelViewEntity.getEntityName() + " view-entity.");
                    }
                    restOfStatement.append(condBuffer.toString());
                    if (i >= modelViewEntity.getViewLinksSize() - 1) continue;
                    restOfStatement.append(')');
                }
                sql.append(openParens.toString());
                sql.append(restOfStatement.toString());
                Iterator<Map.Entry<String, ModelViewEntity.ModelMemberEntity>> meIter = modelViewEntity.getMemberModelMemberEntities().entrySet().iterator();
                boolean bl = fromEmpty = restOfStatement.length() == 0;
                while (meIter.hasNext()) {
                    Map.Entry<String, ModelViewEntity.ModelMemberEntity> entry = meIter.next();
                    ModelEntity fromEntity = modelViewEntity.getMemberModelEntity(entry.getKey());
                    if (joinedAliasSet.contains(entry.getKey())) continue;
                    if (!fromEmpty) {
                        sql.append(", ");
                    }
                    fromEmpty = false;
                    sql.append(SqlJdbcUtil.makeViewTable(fromEntity, datasourceInfo));
                    sql.append(' ');
                    sql.append(entry.getKey());
                }
                return sql.toString();
            } else {
                if (!"theta-oracle".equals(datasourceInfo.getJoinStyle()) && !"theta-mssql".equals(datasourceInfo.getJoinStyle())) throw new GenericModelException("The join-style " + datasourceInfo.getJoinStyle() + " is not yet supported");
                Iterator<Map.Entry<String, ModelViewEntity.ModelMemberEntity>> meIter = modelViewEntity.getMemberModelMemberEntities().entrySet().iterator();
                while (meIter.hasNext()) {
                    Map.Entry<String, ModelViewEntity.ModelMemberEntity> entry = meIter.next();
                    ModelEntity fromEntity = modelViewEntity.getMemberModelEntity(entry.getKey());
                    sql.append(SqlJdbcUtil.makeViewTable(fromEntity, datasourceInfo));
                    sql.append(' ');
                    sql.append(entry.getKey());
                    if (!meIter.hasNext()) continue;
                    sql.append(", ");
                }
            }
            return sql.toString();
        } else {
            sql.append(modelEntity.getTableName(datasourceInfo));
        }
        return sql.toString();
    }

    public static String makeWhereStringFromFields(List<ModelField> modelFields, Map<String, ?> fieldValues, String operator) {
        return SqlJdbcUtil.makeWhereStringFromFields(modelFields, fieldValues, operator, null);
    }

    public static int countWhereStringParametersFromFields(List<ModelField> modelFields, Map<String, ?> fieldValues) {
        if (modelFields == null || modelFields.isEmpty()) {
            return 0;
        }
        int parameterCount = 0;
        for (ModelField modelField : modelFields) {
            Object fieldValue = fieldValues.get(modelField.getName());
            if (fieldValue == null) continue;
            ++parameterCount;
        }
        return parameterCount;
    }

    public static String makeWhereStringFromFields(List<ModelField> modelFields, Map<String, ?> fieldValues, String operator, List<? super EntityConditionParam> entityConditionParams) {
        if (modelFields == null || modelFields.isEmpty()) {
            return "";
        }
        StringBuilder returnString = new StringBuilder();
        Iterator<ModelField> iter = modelFields.iterator();
        while (iter.hasNext()) {
            ModelField modelField = iter.next();
            returnString.append(modelField.getColName());
            Object fieldValue = fieldValues.get(modelField.getName());
            if (fieldValue == null) {
                returnString.append(" IS NULL");
            } else {
                returnString.append("=?");
                if (entityConditionParams != null) {
                    entityConditionParams.add(new EntityConditionParam(modelField, fieldValue));
                }
            }
            if (!iter.hasNext()) continue;
            returnString.append(' ');
            returnString.append(operator);
            returnString.append(' ');
        }
        return returnString.toString();
    }

    public static String makeWhereClause(ModelEntity modelEntity, List<ModelField> modelFields, Map<String, ?> fields, String operator, String joinStyle) throws GenericEntityException {
        String viewClause;
        StringBuilder whereString = new StringBuilder("");
        if (modelFields != null && modelFields.size() > 0) {
            whereString.append(SqlJdbcUtil.makeWhereStringFromFields(modelFields, fields, "AND"));
        }
        if ((viewClause = SqlJdbcUtil.makeViewWhereClause(modelEntity, joinStyle)).length() > 0) {
            if (whereString.length() > 0) {
                whereString.append(' ');
                whereString.append(operator);
                whereString.append(' ');
            }
            whereString.append(viewClause);
        }
        if (whereString.length() > 0) {
            return " WHERE " + whereString.toString();
        }
        return "";
    }

    public static String makeViewWhereClause(ModelEntity modelEntity, String joinStyle) throws GenericEntityException {
        if (modelEntity instanceof ModelViewEntity) {
            StringBuilder whereString = new StringBuilder("");
            ModelViewEntity modelViewEntity = (ModelViewEntity)modelEntity;
            if (!"ansi".equals(joinStyle)) {
                if ("theta-oracle".equals(joinStyle) || "theta-mssql".equals(joinStyle)) {
                    boolean isOracleStyle = "theta-oracle".equals(joinStyle);
                    boolean isMssqlStyle = "theta-mssql".equals(joinStyle);
                    for (int i = 0; i < modelViewEntity.getViewLinksSize(); ++i) {
                        ModelViewEntity.ModelViewLink viewLink = modelViewEntity.getViewLink(i);
                        ModelEntity linkEntity = modelViewEntity.getMemberModelEntity(viewLink.getEntityAlias());
                        ModelEntity relLinkEntity = modelViewEntity.getMemberModelEntity(viewLink.getRelEntityAlias());
                        if (linkEntity == null) {
                            throw new GenericEntityException("Link entity not found with alias: " + viewLink.getEntityAlias() + " for entity: " + modelViewEntity.getEntityName());
                        }
                        if (relLinkEntity == null) {
                            throw new GenericEntityException("Rel-Link entity not found with alias: " + viewLink.getRelEntityAlias() + " for entity: " + modelViewEntity.getEntityName());
                        }
                        for (int j = 0; j < viewLink.getKeyMapsSize(); ++j) {
                            ModelKeyMap keyMap = viewLink.getKeyMap(j);
                            ModelField linkField = linkEntity.getField(keyMap.getFieldName());
                            ModelField relLinkField = relLinkEntity.getField(keyMap.getRelFieldName());
                            if (whereString.length() > 0) {
                                whereString.append(" AND ");
                            }
                            whereString.append(viewLink.getEntityAlias());
                            whereString.append('.');
                            whereString.append(SqlJdbcUtil.filterColName(linkField.getColName()));
                            if (viewLink.isRelOptional() && keyMap.getConstValue().length() > 0) {
                                throw new GenericEntityException("Constant join arguments not supported for '" + joinStyle + "'.");
                            }
                            if (isMssqlStyle && viewLink.isRelOptional()) {
                                whereString.append('*');
                            }
                            whereString.append('=');
                            if (isOracleStyle && viewLink.isRelOptional()) {
                                whereString.append(" (+) ");
                            }
                            whereString.append(viewLink.getRelEntityAlias());
                            whereString.append('.');
                            whereString.append(SqlJdbcUtil.filterColName(relLinkField.getColName()));
                        }
                    }
                } else {
                    throw new GenericModelException("The join-style " + joinStyle + " is not yet supported");
                }
            }
            if (whereString.length() > 0) {
                return '(' + whereString.toString() + ')';
            }
        }
        return "";
    }

    public static String makeOrderByClause(ModelEntity modelEntity, List<String> orderBy, DatasourceInfo datasourceInfo) {
        return SqlJdbcUtil.makeOrderByClause(modelEntity, orderBy, false, datasourceInfo);
    }

    public static String makeOrderByClause(ModelEntity modelEntity, List<String> orderBy, boolean includeTablenamePrefix, DatasourceInfo datasourceInfo) {
        String fieldPrefix;
        StringBuilder sql = new StringBuilder("");
        String string = fieldPrefix = includeTablenamePrefix ? modelEntity.getTableName(datasourceInfo) + '.' : "";
        if (orderBy != null && orderBy.size() > 0) {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Order by list contains: " + orderBy.size() + " entries."), (String)module);
            }
            LinkedList<String> orderByStrings = new LinkedList<String>();
            for (String keyName : orderBy) {
                String ext = null;
                int spaceIdx = keyName.indexOf(32);
                if (spaceIdx > 0) {
                    ext = keyName.substring(spaceIdx);
                    keyName = keyName.substring(0, spaceIdx);
                }
                if (keyName.startsWith("-") || keyName.startsWith("+")) {
                    ext = keyName.charAt(0) == '-' ? " DESC" : " ASC";
                    keyName = keyName.substring(1);
                }
                for (int fi = 0; fi < modelEntity.getFieldsSize(); ++fi) {
                    ModelField curField = modelEntity.getField(fi);
                    if (!curField.getName().equals(keyName)) continue;
                    if (ext != null) {
                        orderByStrings.add(fieldPrefix + curField.getColName() + ext);
                        continue;
                    }
                    orderByStrings.add(fieldPrefix + curField.getColName());
                }
            }
            if (orderByStrings.size() > 0) {
                sql.append(" ORDER BY ");
                Iterator iter = orderByStrings.iterator();
                while (iter.hasNext()) {
                    String curString = (String)iter.next();
                    sql.append(curString);
                    if (!iter.hasNext()) continue;
                    sql.append(", ");
                }
            }
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("makeOrderByClause: " + sql), (String)module);
        }
        return sql.toString();
    }

    public static String makeViewTable(ModelEntity modelEntity, DatasourceInfo datasourceInfo) throws GenericEntityException {
        if (modelEntity instanceof ModelViewEntity) {
            StringBuilder sql = new StringBuilder("(SELECT ");
            List<ModelField> fields = modelEntity.getFieldsCopy();
            if (fields.size() > 0) {
                String colname = fields.get(0).getColName();
                sql.append(colname);
                sql.append(" AS ");
                sql.append(SqlJdbcUtil.filterColName(colname));
                for (int i = 1; i < fields.size(); ++i) {
                    colname = fields.get(i).getColName();
                    sql.append(", ");
                    sql.append(colname);
                    sql.append(" AS ");
                    sql.append(SqlJdbcUtil.filterColName(colname));
                }
            }
            sql.append(SqlJdbcUtil.makeFromClause(modelEntity, datasourceInfo));
            sql.append(SqlJdbcUtil.makeViewWhereClause(modelEntity, datasourceInfo.getJoinStyle()));
            ModelViewEntity modelViewEntity = (ModelViewEntity)modelEntity;
            String groupByString = modelViewEntity.colNameString(modelViewEntity.getGroupBysCopy(), ", ", "");
            if (UtilValidate.isNotEmpty((String)groupByString)) {
                sql.append(" GROUP BY ");
                sql.append(groupByString);
            }
            sql.append(')');
            return sql.toString();
        }
        return modelEntity.getTableName(datasourceInfo);
    }

    public static String filterColName(String colName) {
        return colName.replace('.', '_').replace('(', '_').replace(')', '_');
    }

    public static void setValues(SQLProcessor sqlP, List<ModelField> list, GenericEntity entity, ModelFieldTypeReader modelFieldTypeReader) throws GenericEntityException {
        for (ModelField curField : list) {
            SqlJdbcUtil.setValue(sqlP, curField, entity, modelFieldTypeReader);
        }
    }

    public static void setValuesWhereClause(SQLProcessor sqlP, List<ModelField> list, GenericValue dummyValue, ModelFieldTypeReader modelFieldTypeReader) throws GenericEntityException {
        for (ModelField curField : list) {
            if (dummyValue.get(curField.getName()) == null) continue;
            SqlJdbcUtil.setValue(sqlP, curField, dummyValue, modelFieldTypeReader);
        }
    }

    public static void setPkValues(SQLProcessor sqlP, ModelEntity modelEntity, GenericEntity entity, ModelFieldTypeReader modelFieldTypeReader) throws GenericEntityException {
        for (int j = 0; j < modelEntity.getPksSize(); ++j) {
            ModelField curField = modelEntity.getPk(j);
            if (entity.dangerousGetNoCheckButFast(curField) == null) continue;
            SqlJdbcUtil.setValue(sqlP, curField, entity, modelFieldTypeReader);
        }
    }

    public static void getValue(ResultSet rs, int ind, ModelField curField, GenericEntity entity, ModelFieldTypeReader modelFieldTypeReader) throws GenericEntityException {
        ModelFieldType mft = modelFieldTypeReader.getModelFieldType(curField.getType());
        if (mft == null) {
            throw new GenericModelException("definition fieldType " + curField.getType() + " not found, cannot getValue for field " + entity.getEntityName() + '.' + curField.getName() + '.');
        }
        String fieldType = mft.getJavaType();
        try {
            FieldType type = SqlJdbcUtil.getFieldType(fieldType);
            switch (type) {
                case STRING: {
                    entity.dangerousSetNoCheckButFast(curField, rs.getString(ind));
                    break;
                }
                case TIMESTAMP: {
                    entity.dangerousSetNoCheckButFast(curField, rs.getTimestamp(ind));
                    break;
                }
                case TIME: {
                    entity.dangerousSetNoCheckButFast(curField, rs.getTime(ind));
                    break;
                }
                case DATE: {
                    entity.dangerousSetNoCheckButFast(curField, rs.getDate(ind));
                    break;
                }
                case INTEGER: {
                    int intValue = rs.getInt(ind);
                    if (rs.wasNull()) {
                        entity.dangerousSetNoCheckButFast(curField, null);
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, intValue);
                    break;
                }
                case LONG: {
                    long longValue = rs.getLong(ind);
                    if (rs.wasNull()) {
                        entity.dangerousSetNoCheckButFast(curField, null);
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, longValue);
                    break;
                }
                case FLOAT: {
                    float floatValue = rs.getFloat(ind);
                    if (rs.wasNull()) {
                        entity.dangerousSetNoCheckButFast(curField, null);
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, Float.valueOf(floatValue));
                    break;
                }
                case DOUBLE: {
                    double doubleValue = rs.getDouble(ind);
                    if (rs.wasNull()) {
                        entity.dangerousSetNoCheckButFast(curField, null);
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, doubleValue);
                    break;
                }
                case BOOLEAN: {
                    boolean booleanValue = rs.getBoolean(ind);
                    if (rs.wasNull()) {
                        entity.dangerousSetNoCheckButFast(curField, null);
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, booleanValue);
                    break;
                }
                case OBJECT: {
                    if (SqlJdbcUtil.isByteArrayType(mft)) {
                        entity.dangerousSetNoCheckButFast(curField, SqlJdbcUtil.getByteArrayAsObject(rs, ind));
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, SqlJdbcUtil.getBlobAsObject(rs, ind));
                    break;
                }
                case BLOB: {
                    entity.dangerousSetNoCheckButFast(curField, rs.getBlob(ind));
                    break;
                }
                case CLOB: {
                    entity.dangerousSetNoCheckButFast(curField, rs.getClob(ind));
                    break;
                }
                case BYTE_ARRAY: {
                    if (SqlJdbcUtil.isByteArrayType(mft)) {
                        entity.dangerousSetNoCheckButFast(curField, rs.getBytes(ind));
                        break;
                    }
                    entity.dangerousSetNoCheckButFast(curField, SqlJdbcUtil.getBlobAsByteArray(rs, ind));
                }
            }
        }
        catch (SQLException sqle) {
            throw new GenericDataSourceException("SQL Exception while getting value: ", sqle);
        }
    }

    @Nullable
    private static Object getByteArrayAsObject(ResultSet rs, int ind) throws SQLException, GenericDataSourceException {
        byte[] bytes = rs.getBytes(ind);
        return bytes != null && bytes.length > 0 ? SerializationUtil.deserialize(new ByteArrayInputStream(bytes)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Object getBlobAsObject(ResultSet rs, int ind) throws SQLException, GenericDataSourceException {
        Blob blob = rs.getBlob(ind);
        if (blob == null || blob.length() <= 0L) {
            return null;
        }
        InputStream is = blob.getBinaryStream();
        try {
            Object object = SerializationUtil.deserialize(is);
            return object;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                Debug.logWarning((Throwable)ioe);
            }
        }
    }

    @Nullable
    private static byte[] getBlobAsByteArray(ResultSet rs, int ind) throws SQLException {
        Blob blob = rs.getBlob(ind);
        if (blob == null) {
            return null;
        }
        long len = blob.length();
        if (len <= 0L) {
            return null;
        }
        if (blob.length() > Integer.MAX_VALUE) {
            throw new SQLException("BLOB exceeds Integer.MAX_VALUE in length; cannot be retrieved as byte array");
        }
        return blob.getBytes(1L, (int)len);
    }

    public static void setValue(SQLProcessor sqlP, ModelField modelField, GenericEntity entity, ModelFieldTypeReader modelFieldTypeReader) throws GenericEntityException {
        Object fieldValue = entity.dangerousGetNoCheckButFast(modelField);
        SqlJdbcUtil.setValue(sqlP, modelField, entity.getEntityName(), fieldValue, modelFieldTypeReader);
    }

    public static void setValue(SQLProcessor sqlP, ModelField modelField, String entityName, Object fieldValue, ModelFieldTypeReader modelFieldTypeReader) throws GenericEntityException {
        Class<?> fieldClass;
        String fieldClassName;
        ModelFieldType mft = modelFieldTypeReader.getModelFieldType(modelField.getType());
        if (mft == null) {
            throw new GenericModelException("GenericDAO.getValue: definition fieldType " + modelField.getType() + " not found, cannot setValue for field " + entityName + '.' + modelField.getName() + '.');
        }
        String fieldType = mft.getJavaType();
        if (!(fieldValue == null || (fieldClassName = (fieldClass = fieldValue.getClass()).getName()).equals(mft.getJavaType()) || fieldClassName.contains(mft.getJavaType()) || "java.lang.Object".equals(mft.getJavaType()))) {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("type of field " + entityName + '.' + modelField.getName() + " is " + fieldClassName + ", was expecting " + mft.getJavaType() + "; this may indicate an error in the configuration or in the class, and may result in an SQL-Java data conversion error. Will use the real field type: " + fieldClassName + ", not the definition."), (String)module);
            }
            fieldType = fieldClassName;
        }
        try {
            FieldType type = SqlJdbcUtil.getFieldType(fieldType);
            switch (type) {
                case STRING: {
                    sqlP.setValue((String)fieldValue);
                    break;
                }
                case TIMESTAMP: {
                    sqlP.setValue((Timestamp)fieldValue);
                    break;
                }
                case TIME: {
                    sqlP.setValue((Time)fieldValue);
                    break;
                }
                case DATE: {
                    sqlP.setValue((Date)fieldValue);
                    break;
                }
                case INTEGER: {
                    sqlP.setValue((Integer)fieldValue);
                    break;
                }
                case LONG: {
                    sqlP.setValue((Long)fieldValue);
                    break;
                }
                case FLOAT: {
                    sqlP.setValue((Float)fieldValue);
                    break;
                }
                case DOUBLE: {
                    sqlP.setValue((Double)fieldValue);
                    break;
                }
                case BOOLEAN: {
                    sqlP.setValue((Boolean)fieldValue);
                    break;
                }
                case OBJECT: {
                    if (SqlJdbcUtil.isByteArrayType(mft)) {
                        sqlP.setByteArrayData(fieldValue);
                        break;
                    }
                    sqlP.setBinaryStream(fieldValue);
                    break;
                }
                case BLOB: {
                    if (fieldValue == null && SqlJdbcUtil.isByteArrayType(mft)) {
                        sqlP.setByteArrayData(null);
                        break;
                    }
                    if (fieldValue instanceof Blob) {
                        sqlP.setValue((Blob)fieldValue);
                        break;
                    }
                    sqlP.setBlob((byte[])fieldValue);
                    break;
                }
                case CLOB: {
                    if (fieldValue instanceof Clob) {
                        sqlP.setValue((Clob)fieldValue);
                        break;
                    }
                    sqlP.setValue((String)fieldValue);
                    break;
                }
                case BYTE_ARRAY: {
                    if (SqlJdbcUtil.isByteArrayType(mft)) {
                        sqlP.setByteArray((byte[])fieldValue);
                        break;
                    }
                    sqlP.setBlob((byte[])fieldValue);
                }
            }
        }
        catch (SQLException sqle) {
            throw new GenericDataSourceException("SQL Exception while setting value: ", sqle);
        }
    }

    private static boolean isByteArrayType(ModelFieldType mft) {
        String type = mft.getSqlType();
        return "BYTEA".equals(type) || "IMAGE".equals(type) || "OTHER".equals(type);
    }

    public static int getType(String javaType) throws GenericNotImplementedException {
        FieldType type = JAVA_TYPE_MAP.get(javaType);
        if (type == null) {
            throw new IllegalArgumentException("Java type " + javaType + " not currently supported. Sorry.");
        }
        return type.getOldTypeNumber();
    }

    @Nonnull
    public static FieldType getFieldType(String javaType) {
        FieldType type = JAVA_TYPE_MAP.get(javaType);
        if (type == null) {
            throw new IllegalArgumentException("Java type " + javaType + " not currently supported. Sorry.");
        }
        return type;
    }

    public static enum FieldType {
        STRING(1, "String", "java.lang.String"),
        TIMESTAMP(2, "Timestamp", "java.sql.Timestamp"),
        TIME(3, "Time", "java.sql.Time"),
        DATE(4, "Date", "java.sql.Date"),
        INTEGER(5, "Integer", "java.lang.Integer"),
        LONG(6, "Long", "java.lang.Long"),
        FLOAT(7, "Float", "java.lang.Float"),
        DOUBLE(8, "Double", "java.lang.Double"),
        BOOLEAN(9, "Boolean", "java.lang.Boolean"),
        OBJECT(10, "Object", "java.lang.Object"),
        CLOB(11, "Clob", "java.sql.Clob"),
        BLOB(12, "Blob", "java.sql.Blob"),
        BYTE_ARRAY(13, "byte[]", "[B");

        private final int oldTypeNumber;
        private final String[] javaTypes;

        private FieldType(int oldTypeNumber, String ... javaTypes) {
            this.oldTypeNumber = oldTypeNumber;
            this.javaTypes = javaTypes;
        }

        public int getOldTypeNumber() {
            return this.oldTypeNumber;
        }

        public boolean matches(String javaType) {
            for (String myJavaType : this.javaTypes) {
                if (!myJavaType.equals(javaType)) continue;
                return true;
            }
            return false;
        }

        static Map<String, FieldType> buildJavaTypeMap() {
            HashMap<Integer, FieldType> typeNumberMapping = new HashMap<Integer, FieldType>(64);
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (FieldType fieldType : FieldType.values()) {
                FieldType collision = typeNumberMapping.put(fieldType.oldTypeNumber, fieldType);
                if (collision != null) {
                    throw new IllegalStateException("FieldType '" + (Object)((Object)fieldType) + "' uses the same value that '" + (Object)((Object)collision) + "' uses for its old type number: " + fieldType.oldTypeNumber);
                }
                for (String javaType : fieldType.javaTypes) {
                    map.put((Object)javaType, (Object)fieldType);
                }
            }
            return map.build();
        }
    }
}

