/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;

public class EntityClause {
    private String firstEntity = "";
    private String secondEntity = "";
    private String firstField = "";
    private String secondField = "";
    private ModelEntity firstModelEntity = null;
    private ModelEntity secondModelEntity = null;
    private EntityOperator interFieldOperation = null;
    private EntityOperator intraFieldOperation = null;
    private boolean useValueForSecondEntity = false;
    private Object value = null;

    public EntityClause() {
    }

    public EntityClause(String firstEntity, String secondEntity, String firstField, String secondField, EntityOperator interFieldOperation, EntityOperator intraFieldOperation) {
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstField = firstField;
        this.secondField = secondField;
        this.interFieldOperation = interFieldOperation;
        this.intraFieldOperation = intraFieldOperation;
    }

    public EntityClause(String firstEntity, String firstField, Object value, EntityOperator interFieldOperation, EntityOperator intraFieldOperation) {
        this.firstEntity = firstEntity;
        this.firstField = firstField;
        this.value = value;
        this.interFieldOperation = interFieldOperation;
        this.intraFieldOperation = intraFieldOperation;
    }

    public String getFirstEntity() {
        return this.firstEntity;
    }

    public String getSecondEntity() {
        return this.secondEntity;
    }

    public String getFirstField() {
        return this.firstField;
    }

    public String getSecondField() {
        return this.secondField;
    }

    public Object getValue() {
        if (this.value == null) {
            this.value = new Object();
        }
        return this.value;
    }

    public EntityOperator getInterFieldOperation() {
        return this.interFieldOperation;
    }

    public EntityOperator getIntraFieldOperation() {
        return this.intraFieldOperation;
    }

    public void setFirstEntity(String firstEntity) {
        this.firstEntity = firstEntity;
    }

    public void setSecondEntity(String secondEntity) {
        this.secondEntity = secondEntity;
    }

    public void setFirstField(String firstField) {
        this.firstField = firstField;
    }

    public void setSecondField(String secondField) {
        this.secondField = secondField;
    }

    public void setInterFieldOperation(EntityOperator interFieldOperation) {
        this.interFieldOperation = interFieldOperation;
    }

    public void setIntraFieldOperation(EntityOperator intraFieldOperation) {
        this.intraFieldOperation = intraFieldOperation;
    }

    protected void setModelEntities(ModelReader modelReader) throws GenericEntityException {
        this.firstModelEntity = modelReader.getModelEntity(this.firstEntity);
        if (this.secondEntity != null && !this.secondEntity.equals("")) {
            this.secondModelEntity = modelReader.getModelEntity(this.secondEntity);
        }
    }

    protected ModelEntity getFirstModelEntity() {
        return this.firstModelEntity;
    }

    protected ModelEntity getSecondModelEntity() {
        return this.secondModelEntity;
    }

    public String toString() {
        StringBuilder outputBuffer = new StringBuilder();
        outputBuffer.append("[firstEntity," + (this.firstEntity == null ? "null" : this.firstEntity) + "]");
        outputBuffer.append("[secondEntity," + (this.secondEntity == null ? "null" : this.secondEntity) + "]");
        outputBuffer.append("[firstField," + (this.firstField == null ? "null" : this.firstField) + "]");
        outputBuffer.append("[secondField," + (this.secondField == null ? "null" : this.secondField) + "]");
        outputBuffer.append("[firstModelEntity," + (this.firstModelEntity == null ? "null" : (this.firstModelEntity.getEntityName() == null ? "null" : this.firstModelEntity.getEntityName())) + "]");
        outputBuffer.append("[secondModelEntity," + (this.secondModelEntity == null ? "null" : (this.secondModelEntity.getEntityName() == null ? "null" : this.secondModelEntity.getEntityName())) + "]");
        outputBuffer.append("[interFieldOperation," + (this.interFieldOperation == null ? "null" : (this.interFieldOperation.getCode() == null ? "null" : this.interFieldOperation.getCode())) + "]");
        outputBuffer.append("[intraFieldOperation," + (this.intraFieldOperation == null ? "null" : (this.intraFieldOperation.getCode() == null ? "null" : this.intraFieldOperation.getCode())) + "]");
        outputBuffer.append("[value," + (this.getValue().toString() == null ? "null" : this.getValue().toString()) + "]");
        return outputBuffer.toString();
    }
}

