/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractDatabaseType;
import org.ofbiz.core.util.Debug;

class Oracle8IDatabaseType
extends AbstractDatabaseType {
    final String PRODUCT_VERSION_PREFIX = "Oracle8i Enterprise Edition Release ";

    public Oracle8IDatabaseType() {
        super("Oracle 8i", "oracle", new String[]{"Oracle"});
    }

    @Override
    public boolean matchesConnection(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        int majorVersion = 0;
        int minorVersion = 0;
        try {
            majorVersion = metaData.getDatabaseMajorVersion();
            minorVersion = metaData.getDatabaseMinorVersion();
        }
        catch (AbstractMethodError ame) {
            try {
                System.out.println("DatabaseType.matchesConnection: AbstractMethodException encountered " + ame);
                String dbVersion = metaData.getDatabaseProductVersion();
                if (dbVersion != null && dbVersion.length() > "Oracle8i Enterprise Edition Release ".length()) {
                    StringTokenizer versionTokens = new StringTokenizer(dbVersion.substring("Oracle8i Enterprise Edition Release ".length()), ".");
                    if (versionTokens.hasMoreElements()) {
                        majorVersion = Oracle8IDatabaseType.parseVersionToken(versionTokens.nextToken());
                    }
                    if (versionTokens.hasMoreElements()) {
                        minorVersion = Oracle8IDatabaseType.parseVersionToken(versionTokens.nextToken());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("DatabaseType.matchesConnection: Exception occured while parsing version number string." + e);
                return false;
            }
        }
        return this.productNameMatches(con) && Oracle8IDatabaseType.versionGreaterThanOrEqual(8, Integer.MAX_VALUE, majorVersion, minorVersion);
    }

    private static int parseVersionToken(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            Debug.log((Throwable)nfe, (String)("Unable to parse version number token " + token + ". Returning 0."));
            return 0;
        }
    }
}

