/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.util.Debug;

public class TransactionFactory {
    public static TransactionFactoryInterface transactionFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionFactoryInterface getTransactionFactory() {
        if (transactionFactory != null) return transactionFactory;
        Class<TransactionFactory> clazz = TransactionFactory.class;
        synchronized (TransactionFactory.class) {
            if (transactionFactory != null) return transactionFactory;
            try {
                String className = EntityConfigUtil.getInstance().getTxFactoryClass();
                if (className == null) {
                    throw new IllegalStateException("Could not find transaction factory class name definition");
                }
                Class<?> tfClass = null;
                if (className != null && className.length() > 0) {
                    try {
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        tfClass = loader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        Debug.logWarning((Throwable)e);
                        throw new IllegalStateException("Error loading TransactionFactory class \"" + className + "\": " + e.getMessage());
                    }
                }
                try {
                    transactionFactory = (TransactionFactoryInterface)tfClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    Debug.logWarning((Throwable)e);
                    throw new IllegalStateException("Error loading TransactionFactory class \"" + className + "\": " + e.getMessage());
                }
                catch (InstantiationException e) {
                    Debug.logWarning((Throwable)e);
                    throw new IllegalStateException("Error loading TransactionFactory class \"" + className + "\": " + e.getMessage());
                }
            }
            catch (SecurityException e) {
                Debug.logError((Throwable)e);
                throw new IllegalStateException("Error loading TransactionFactory class: " + e.getMessage());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return transactionFactory;
        }
    }

    public static TransactionManager getTransactionManager() {
        return TransactionFactory.getTransactionFactory().getTransactionManager();
    }

    public static UserTransaction getUserTransaction() {
        return TransactionFactory.getTransactionFactory().getUserTransaction();
    }

    public static String getTxMgrName() {
        return TransactionFactory.getTransactionFactory().getTxMgrName();
    }

    public static Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        return TransactionFactory.getTransactionFactory().getConnection(helperName);
    }
}

