/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.ConnectionProvider;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelIndex;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilValidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtil {
    public static final String module = DatabaseUtil.class.getName();
    protected String helperName;
    protected ModelFieldTypeReader modelFieldTypeReader;
    protected DatasourceInfo datasourceInfo;
    private final ConnectionProvider connectionProvider;

    public DatabaseUtil(String helperName) {
        this.helperName = helperName;
        this.modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        this.datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        this.connectionProvider = ConnectionFactory.provider;
    }

    DatabaseUtil(String helperName, ModelFieldTypeReader modelFieldTypeReader, DatasourceInfo datasourceInfo, ConnectionProvider connectionProvider) {
        this.helperName = helperName;
        this.modelFieldTypeReader = modelFieldTypeReader;
        this.datasourceInfo = datasourceInfo;
        this.connectionProvider = connectionProvider;
    }

    public Connection getConnection() throws SQLException, GenericEntityException {
        return this.connectionProvider.getConnection(this.helperName);
    }

    public void checkDb(Map modelEntities, Collection messages, boolean addMissing) {
        ModelRelation modelRelation;
        String entityName;
        String indErrMsg;
        String errMsg;
        UtilTimer timer = new UtilTimer();
        timer.timerString("Start - Before Get Database Meta Data");
        TreeSet tableNames = this.getTableNames(messages);
        TreeSet fkTableNames = tableNames == null ? null : new TreeSet(tableNames);
        TreeSet indexTableNames = tableNames == null ? null : new TreeSet(tableNames);
        HashMap<String, ModelEntity> existingTableEntities = new HashMap<String, ModelEntity>();
        if (tableNames == null) {
            this.error("Could not get table name information from the database, aborting.", messages);
            return;
        }
        timer.timerString("After Get All Table Names");
        Map colInfo = this.getColumnInfo(tableNames, messages);
        if (colInfo == null) {
            this.error("Could not get column information from the database, aborting.", messages);
            return;
        }
        timer.timerString("After Get All Column Info");
        timer.timerString("Before Individual Table/Column Check");
        ArrayList modelEntityList = new ArrayList(modelEntities.values());
        Collections.sort(modelEntityList);
        Iterator modelEntityIter = modelEntityList.iterator();
        int curEnt = 0;
        int totalEnt = modelEntityList.size();
        LinkedList<ModelEntity> entitiesAdded = new LinkedList<ModelEntity>();
        while (modelEntityIter.hasNext()) {
            ++curEnt;
            ModelEntity entity = (ModelEntity)modelEntityIter.next();
            String entityName2 = entity.getEntityName();
            if (entity instanceof ModelViewEntity) {
                this.verbose("(" + timer.timeSinceLast() + "ms) NOT Checking #" + curEnt + "/" + totalEnt + " View Entity " + entityName2, messages);
                continue;
            }
            String tableName = entity.getTableName(this.datasourceInfo);
            String entMessage = "(" + timer.timeSinceLast() + "ms) Checking #" + curEnt + "/" + totalEnt + " Entity " + entityName2 + " with table " + tableName;
            this.verbose(entMessage, messages);
            String upperTableName = tableName.toUpperCase();
            if (tableNames.contains(upperTableName)) {
                int numCols;
                tableNames.remove(upperTableName);
                existingTableEntities.put(entity.getPlainTableName(), entity);
                if (colInfo == null) continue;
                HashMap<String, ModelField> fieldColNames = new HashMap<String, ModelField>();
                for (int fnum = 0; fnum < entity.getFieldsSize(); ++fnum) {
                    ModelField field = entity.getField(fnum);
                    fieldColNames.put(field.getColName().toUpperCase(), field);
                }
                List colList = (List)colInfo.get(upperTableName);
                if (colList != null) {
                    for (numCols = 0; numCols < colList.size(); ++numCols) {
                        ColumnCheckInfo ccInfo = (ColumnCheckInfo)colList.get(numCols);
                        if (fieldColNames.containsKey(ccInfo.columnName)) {
                            ModelField field = null;
                            field = (ModelField)fieldColNames.remove(ccInfo.columnName);
                            this.checkFieldType(entity, field, ccInfo, messages);
                            continue;
                        }
                        this.warn("Column \"" + ccInfo.columnName + "\" of table \"" + tableName + "\" of entity \"" + entityName2 + "\" exists in the database but has no corresponding field", messages);
                    }
                }
                if (numCols != entity.getFieldsSize()) {
                    String message = "Entity \"" + entityName2 + "\" has " + entity.getFieldsSize() + " fields but table \"" + tableName + "\" has " + numCols + " columns.";
                    this.warn(message, messages);
                }
                for (String colName : fieldColNames.keySet()) {
                    ModelField field = (ModelField)fieldColNames.get(colName);
                    this.warn("Field \"" + field.getName() + "\" of entity \"" + entityName2 + "\" is missing its corresponding column \"" + field.getColName() + "\"", messages);
                    if (!addMissing) continue;
                    errMsg = this.addColumn(entity, field);
                    if (errMsg != null && errMsg.length() > 0) {
                        this.error("Could not add column \"" + field.getColName() + "\" to table \"" + tableName + "\"", messages);
                        this.error(errMsg, messages);
                        continue;
                    }
                    this.important("Added column \"" + field.getColName() + "\" to table \"" + tableName + "\"", messages);
                }
                continue;
            }
            this.warn("Entity \"" + entityName2 + "\" has no table in the database", messages);
            if (!addMissing) continue;
            String errMsg2 = this.createTable(entity, modelEntities, false, this.datasourceInfo.isUsePkConstraintNames(), this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.getFkStyle(), this.datasourceInfo.isUseFkInitiallyDeferred());
            if (errMsg2 != null && errMsg2.length() > 0) {
                this.error("Could not create table \"" + tableName + "\"", messages);
                this.error(errMsg2, messages);
                continue;
            }
            entitiesAdded.add(entity);
            this.important("Created table \"" + tableName + "\"", messages);
        }
        timer.timerString("After Individual Table/Column Check");
        Iterator tableNamesIter = tableNames.iterator();
        while (tableNamesIter != null && tableNamesIter.hasNext()) {
            String tableName = (String)tableNamesIter.next();
            this.warn("Table named \"" + tableName + "\" exists in the database but has no corresponding entity", messages);
        }
        if (this.datasourceInfo.isUseFks()) {
            for (ModelEntity curEntity : entitiesAdded) {
                String errMsg3 = this.createForeignKeys(curEntity, modelEntities, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.getFkStyle(), this.datasourceInfo.isUseFkInitiallyDeferred());
                if (errMsg3 != null && errMsg3.length() > 0) {
                    this.error("Could not create foreign keys for entity \"" + curEntity.getEntityName() + "\"", messages);
                    this.error(errMsg3, messages);
                    continue;
                }
                this.important("Created foreign keys for entity \"" + curEntity.getEntityName() + "\"", messages);
            }
        }
        if (this.datasourceInfo.isUseFkIndices()) {
            for (ModelEntity curEntity : entitiesAdded) {
                indErrMsg = this.createForeignKeyIndices(curEntity, this.datasourceInfo.getConstraintNameClipLength());
                if (indErrMsg != null && indErrMsg.length() > 0) {
                    this.error("Could not create foreign key indices for entity \"" + curEntity.getEntityName() + "\"", messages);
                    this.error(indErrMsg, messages);
                    continue;
                }
                this.important("Created foreign key indices for entity \"" + curEntity.getEntityName() + "\"", messages);
            }
        }
        if (this.datasourceInfo.isUseIndices()) {
            for (ModelEntity curEntity : entitiesAdded) {
                indErrMsg = this.createDeclaredIndices(curEntity);
                if (indErrMsg != null && indErrMsg.length() > 0) {
                    this.error("Could not create declared indices for entity \"" + curEntity.getEntityName() + "\"", messages);
                    this.error(indErrMsg, messages);
                    continue;
                }
                this.important("Created declared indices for entity \"" + curEntity.getEntityName() + "\"", messages);
            }
            this.createMissingIndices(existingTableEntities, messages);
        }
        if (this.datasourceInfo.isUseFks() && this.datasourceInfo.isCheckForeignKeysOnStart()) {
            int numFksCreated = 0;
            Map refTableInfoMap = this.getReferenceInfo(fkTableNames, messages);
            if (refTableInfoMap != null) {
                for (ModelEntity entity : modelEntityList) {
                    entityName = entity.getEntityName();
                    if (entity instanceof ModelViewEntity) {
                        this.verbose("NOT Checking View Entity " + entity.getEntityName(), messages);
                        continue;
                    }
                    Map rcInfoMap = (Map)refTableInfoMap.get(entity.getTableName(this.datasourceInfo));
                    Iterator relations = entity.getRelationsIterator();
                    boolean createdConstraints = false;
                    while (relations.hasNext()) {
                        String errMsg4;
                        modelRelation = (ModelRelation)relations.next();
                        if (!"one".equals(modelRelation.getType())) continue;
                        ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
                        String relConstraintName = this.makeFkConstraintName(modelRelation, this.datasourceInfo.getConstraintNameClipLength());
                        ReferenceCheckInfo rcInfo = null;
                        if (rcInfoMap != null) {
                            rcInfo = (ReferenceCheckInfo)rcInfoMap.get(relConstraintName);
                        }
                        if (rcInfo != null) {
                            rcInfoMap.remove(relConstraintName);
                            continue;
                        }
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("No Foreign Key Constraint " + relConstraintName + " found in entity " + entityName));
                        }
                        if ((errMsg4 = this.createForeignKey(entity, modelRelation, relModelEntity, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.getFkStyle(), this.datasourceInfo.isUseFkInitiallyDeferred())) != null && errMsg4.length() > 0) {
                            this.error("Could not create foreign key " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"", messages);
                            this.error(errMsg4, messages);
                            continue;
                        }
                        this.verbose("Created foreign key " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"", messages);
                        createdConstraints = true;
                        ++numFksCreated;
                    }
                    if (createdConstraints) {
                        this.important("Created foreign key(s) for entity \"" + entity.getEntityName() + "\"", messages);
                    }
                    if (rcInfoMap == null) continue;
                    for (String rcKeyLeft : rcInfoMap.keySet()) {
                        Debug.logImportant((String)("Unknown Foreign Key Constraint " + rcKeyLeft + " found in table " + entity.getTableName(this.datasourceInfo)));
                    }
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Created " + numFksCreated + " fk refs"));
            }
        }
        if (this.datasourceInfo.isUseFkIndices() && this.datasourceInfo.isCheckFkIndicesOnStart()) {
            int numIndicesCreated = 0;
            Map tableIndexListMap = this.getIndexInfo(indexTableNames, messages);
            if (tableIndexListMap != null) {
                for (ModelEntity entity : modelEntityList) {
                    entityName = entity.getEntityName();
                    if (entity instanceof ModelViewEntity) {
                        this.verbose("NOT Checking View Entity " + entity.getEntityName(), messages);
                        continue;
                    }
                    TreeSet tableIndexList = (TreeSet)tableIndexListMap.get(entity.getTableName(this.datasourceInfo));
                    if (tableIndexList == null) {
                        String message;
                        String indErrMsg2 = this.createForeignKeyIndices(entity, this.datasourceInfo.getConstraintNameClipLength());
                        if (indErrMsg2 != null && indErrMsg2.length() > 0) {
                            message = "Could not create foreign key indices for entity \"" + entity.getEntityName() + "\"";
                            this.error(message, messages);
                            this.error(indErrMsg2, messages);
                        } else {
                            message = "Created foreign key indices for entity \"" + entity.getEntityName() + "\"";
                            this.important(message, messages);
                        }
                    } else {
                        boolean createdConstraints = false;
                        Iterator relations = entity.getRelationsIterator();
                        while (relations.hasNext()) {
                            String message;
                            modelRelation = (ModelRelation)relations.next();
                            if (!"one".equals(modelRelation.getType())) continue;
                            String relConstraintName = this.makeFkConstraintName(modelRelation, this.datasourceInfo.getConstraintNameClipLength());
                            if (tableIndexList.contains(relConstraintName)) {
                                tableIndexList.remove(relConstraintName);
                                continue;
                            }
                            if (Debug.verboseOn()) {
                                Debug.logVerbose((String)("No Index " + relConstraintName + " found for entity " + entityName));
                            }
                            if ((errMsg = this.createForeignKeyIndex(entity, modelRelation, this.datasourceInfo.getConstraintNameClipLength())) != null && errMsg.length() > 0) {
                                message = "Could not create foreign key index " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"";
                                this.error(message, messages);
                                this.error(errMsg, messages);
                                continue;
                            }
                            message = "Created foreign key index " + relConstraintName + " for entity \"" + entity.getEntityName() + "\"";
                            this.verbose(message, messages);
                            createdConstraints = true;
                            ++numIndicesCreated;
                        }
                        if (createdConstraints) {
                            this.important("Created foreign key index/indices for entity \"" + entity.getEntityName() + "\"", messages);
                        }
                    }
                    if (tableIndexList == null) continue;
                    for (String indexLeft : tableIndexList) {
                        Debug.logImportant((String)("Unknown Index " + indexLeft + " found in table " + entity.getTableName(this.datasourceInfo)));
                    }
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Created " + numIndicesCreated + " indices"));
            }
        }
        timer.timerString("Finished Checking Entity Database");
    }

    void checkFieldType(ModelEntity entity, ModelField field, ColumnCheckInfo ccInfo, Collection messages) {
        ModelFieldType modelFieldType = this.modelFieldTypeReader.getModelFieldType(field.getType());
        if (modelFieldType != null) {
            String message;
            String typeName;
            String fullTypeStr = modelFieldType.getSqlType();
            int columnSize = -1;
            int decimalDigits = -1;
            int openParen = fullTypeStr.indexOf(40);
            int closeParen = fullTypeStr.indexOf(41);
            int comma = fullTypeStr.indexOf(44);
            if (openParen > 0 && closeParen > 0 && closeParen > openParen) {
                String csStr;
                typeName = fullTypeStr.substring(0, openParen);
                if (comma > 0 && comma > openParen && comma < closeParen) {
                    csStr = fullTypeStr.substring(openParen + 1, comma);
                    try {
                        columnSize = Integer.parseInt(csStr);
                    }
                    catch (NumberFormatException e) {
                        Debug.logError((Throwable)e, (String)module);
                    }
                    String ddStr = fullTypeStr.substring(comma + 1, closeParen);
                    try {
                        decimalDigits = Integer.parseInt(ddStr);
                    }
                    catch (NumberFormatException e) {
                        Debug.logError((Throwable)e, (String)module);
                    }
                } else {
                    csStr = fullTypeStr.substring(openParen + 1, closeParen);
                    try {
                        columnSize = Integer.parseInt(csStr);
                    }
                    catch (NumberFormatException e) {
                        Debug.logError((Throwable)e, (String)module);
                    }
                }
            } else {
                typeName = fullTypeStr;
            }
            if (UtilValidate.isNotEmpty((String)modelFieldType.getSqlTypeAlias())) {
                typeName = modelFieldType.getSqlTypeAlias();
            }
            if (!ccInfo.typeName.equals(typeName.toUpperCase())) {
                message = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" is of type \"" + ccInfo.typeName + "\" in the database, but is defined as type \"" + typeName + "\" in the entity definition.";
                this.error(message, messages);
            }
            if (columnSize != -1 && ccInfo.columnSize != -1 && columnSize != ccInfo.columnSize) {
                message = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has a column size of \"" + ccInfo.columnSize + "\" in the database, but is defined to have a column size of \"" + columnSize + "\" in the entity definition.";
                this.warn(message, messages);
            }
            if (decimalDigits != -1 && decimalDigits != ccInfo.decimalDigits) {
                message = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has a decimalDigits of \"" + ccInfo.decimalDigits + "\" in the database, but is defined to have a decimalDigits of \"" + decimalDigits + "\" in the entity definition.";
                this.warn(message, messages);
            }
        } else {
            String message = "Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has a field type name of \"" + field.getType() + "\" which is not found in the field type definitions";
            this.error(message, messages);
        }
    }

    void createMissingIndices(Map<String, ModelEntity> tableToModelEntities, Collection messages) {
        Map indexInfo = this.getIndexInfo(tableToModelEntities.keySet(), messages, true);
        for (Map.Entry indexInfoEntry : indexInfo.entrySet()) {
            String tableName = (String)indexInfoEntry.getKey();
            Set actualIndexes = (Set)indexInfoEntry.getValue();
            ModelEntity modelEntity = tableToModelEntities.get(tableName);
            Iterator indexesIterator = modelEntity.getIndexesIterator();
            StringBuffer retMsgsBuffer = new StringBuffer();
            while (indexesIterator.hasNext()) {
                String retMsg;
                ModelIndex modelIndex = (ModelIndex)indexesIterator.next();
                if (actualIndexes.contains(modelIndex.getName().toUpperCase())) continue;
                if (Debug.infoOn()) {
                    Debug.logInfo((String)("Missing index '" + modelIndex.getName() + "' on existing table '" + tableName + "' ...creating"));
                }
                if ((retMsg = this.createDeclaredIndex(modelEntity, modelIndex)) == null || retMsg.length() <= 0) continue;
                if (retMsgsBuffer.length() > 0) {
                    retMsgsBuffer.append("\n");
                }
                retMsgsBuffer.append(retMsg);
            }
            if (retMsgsBuffer.length() <= 0) continue;
            this.error("Could not create missing indices for entity \"" + modelEntity.getEntityName() + "\"", messages);
            this.error(retMsgsBuffer.toString(), messages);
        }
    }

    public List induceModelFromDb(Collection messages) {
        TreeSet tableNames = this.getTableNames(messages);
        Map colInfo = this.getColumnInfo(tableNames, messages);
        LinkedList<ModelEntity> newEntList = new LinkedList<ModelEntity>();
        for (String tableName : new TreeSet(colInfo.keySet())) {
            ArrayList colList = (ArrayList)colInfo.get(tableName);
            ModelEntity newEntity = new ModelEntity(tableName, colList, this.modelFieldTypeReader);
            newEntList.add(newEntity);
        }
        return newEntList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet getTableNames(Collection messages) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to esablish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to esablish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        if (connection == null) {
            this.error("Unable to esablish a connection with the database, no additional information available.", messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database meta data... Error was:" + sqle.toString(), messages);
            return null;
        }
        if (dbData == null) {
            Debug.logWarning((String)"Unable to get database meta data; method returned null", (String)module);
        }
        this.logDbInfo(dbData);
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Table Info From Database");
        }
        TreeSet<String> tableNames = new TreeSet<String>();
        ResultSet tableSet = null;
        try {
            String[] types = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
            String lookupSchemaName = this.lookupSchemaName(dbData);
            tableSet = dbData.getTables(null, lookupSchemaName, null, types);
            if (tableSet == null) {
                Debug.logWarning((String)"getTables returned null set", (String)module);
            }
        }
        catch (SQLException sqle) {
            this.error("Unable to get list of table information, let's try the create anyway... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return tableNames;
        }
        try {
            while (tableSet.next()) {
                try {
                    String tableName = tableSet.getString("TABLE_NAME");
                    tableName = tableName == null ? null : tableName.toUpperCase();
                    tableName = this.convertToSchemaTableName(tableName, dbData);
                    String tableType = tableSet.getString("TABLE_TYPE");
                    String string = tableType = tableType == null ? null : tableType.toUpperCase();
                    if (tableType != null && !"TABLE".equals(tableType) && !"VIEW".equals(tableType) && !"ALIAS".equals(tableType) && !"SYNONYM".equals(tableType)) continue;
                    tableNames.add(tableName);
                }
                catch (SQLException sqle) {
                    this.error("Error getting table information... Error was:" + sqle.toString(), messages);
                }
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting next table information... Error was:" + sqle.toString(), messages);
        }
        finally {
            try {
                tableSet.close();
            }
            catch (SQLException sqle) {
                this.error("Unable to close ResultSet for table list, continuing anyway... Error was:" + sqle.toString(), messages);
            }
            this.cleanup(connection, messages);
        }
        return tableNames;
    }

    private String lookupSchemaName(DatabaseMetaData dbData) throws SQLException {
        String lookupSchemaName = null;
        if (dbData.supportsSchemasInTableDefinitions()) {
            lookupSchemaName = this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 ? this.datasourceInfo.getSchemaName() : dbData.getUserName();
        }
        return lookupSchemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getColumnInfo(Set tableNames, Collection messages) {
        if (tableNames.size() == 0) {
            return new HashMap();
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to esablish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to esablish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database meta data... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Column Info From Database");
        }
        HashMap<String, ArrayList<ColumnCheckInfo>> colInfo = new HashMap<String, ArrayList<ColumnCheckInfo>>();
        try {
            String lookupSchemaName = this.lookupSchemaName(dbData);
            ResultSet rsCols = dbData.getColumns(null, lookupSchemaName, null, null);
            while (rsCols.next()) {
                try {
                    ColumnCheckInfo ccInfo = new ColumnCheckInfo();
                    ccInfo.tableName = rsCols.getString("TABLE_NAME");
                    ccInfo.tableName = ccInfo.tableName == null ? null : ccInfo.tableName.toUpperCase();
                    ccInfo.tableName = this.convertToSchemaTableName(ccInfo.tableName, dbData);
                    if (!tableNames.contains(ccInfo.tableName)) continue;
                    ccInfo.columnName = rsCols.getString("COLUMN_NAME");
                    ccInfo.columnName = ccInfo.columnName == null ? null : ccInfo.columnName.toUpperCase();
                    ccInfo.typeName = rsCols.getString("TYPE_NAME");
                    ccInfo.typeName = ccInfo.typeName == null ? null : ccInfo.typeName.toUpperCase();
                    ccInfo.columnSize = rsCols.getInt("COLUMN_SIZE");
                    ccInfo.decimalDigits = rsCols.getInt("DECIMAL_DIGITS");
                    ccInfo.isNullable = rsCols.getString("IS_NULLABLE");
                    ccInfo.isNullable = ccInfo.isNullable == null ? null : ccInfo.isNullable.toUpperCase();
                    ArrayList<ColumnCheckInfo> tableColInfo = (ArrayList<ColumnCheckInfo>)colInfo.get(ccInfo.tableName);
                    if (tableColInfo == null) {
                        tableColInfo = new ArrayList<ColumnCheckInfo>();
                        colInfo.put(ccInfo.tableName, tableColInfo);
                    }
                    tableColInfo.add(ccInfo);
                }
                catch (SQLException sqle) {
                    this.error("Error getting column info for column. Error was:" + sqle.toString(), messages);
                }
            }
            try {
                rsCols.close();
            }
            catch (SQLException sqle) {
                this.error("Unable to close ResultSet for column list, continuing anyway... Error was:" + sqle.toString(), messages);
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting column meta data for Error was:" + sqle.toString() + ". Not checking columns.", messages);
        }
        finally {
            this.cleanup(connection, messages);
        }
        return colInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getReferenceInfo(Set tableNames, Collection messages) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to esablish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to esablish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database meta data... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Foreign Key (Reference) Info From Database");
        }
        HashMap refInfo = new HashMap();
        try {
            String lookupSchemaName = this.lookupSchemaName(dbData);
            ResultSet rsCols = dbData.getImportedKeys(null, lookupSchemaName, null);
            int totalFkRefs = 0;
            while (rsCols.next()) {
                try {
                    HashMap<String, ReferenceCheckInfo> tableRefInfo;
                    ReferenceCheckInfo rcInfo = new ReferenceCheckInfo();
                    rcInfo.pkTableName = rsCols.getString("PKTABLE_NAME");
                    rcInfo.pkTableName = rcInfo.pkTableName == null ? null : rcInfo.pkTableName.toUpperCase();
                    rcInfo.pkColumnName = rsCols.getString("PKCOLUMN_NAME");
                    rcInfo.pkColumnName = rcInfo.pkColumnName == null ? null : rcInfo.pkColumnName.toUpperCase();
                    rcInfo.fkTableName = rsCols.getString("FKTABLE_NAME");
                    String string = rcInfo.fkTableName = rcInfo.fkTableName == null ? null : rcInfo.fkTableName.toUpperCase();
                    if (!tableNames.contains(rcInfo.fkTableName)) continue;
                    rcInfo.fkColumnName = rsCols.getString("FKCOLUMN_NAME");
                    rcInfo.fkColumnName = rcInfo.fkColumnName == null ? null : rcInfo.fkColumnName.toUpperCase();
                    rcInfo.fkName = rsCols.getString("FK_NAME");
                    String string2 = rcInfo.fkName = rcInfo.fkName == null ? null : rcInfo.fkName.toUpperCase();
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)("Got: " + rcInfo.toString()));
                    }
                    if ((tableRefInfo = (HashMap<String, ReferenceCheckInfo>)refInfo.get(rcInfo.fkTableName)) == null) {
                        tableRefInfo = new HashMap<String, ReferenceCheckInfo>();
                        refInfo.put(rcInfo.fkTableName, tableRefInfo);
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("Adding new Map for table: " + rcInfo.fkTableName));
                        }
                    }
                    if (!tableRefInfo.containsKey(rcInfo.fkName)) {
                        ++totalFkRefs;
                    }
                    tableRefInfo.put(rcInfo.fkName, rcInfo);
                }
                catch (SQLException sqle) {
                    this.error("Error getting fk reference info for table. Error was:" + sqle.toString(), messages);
                }
            }
            try {
                rsCols.close();
            }
            catch (SQLException sqle) {
                this.error("Unable to close ResultSet for fk reference list, continuing anyway... Error was:" + sqle.toString(), messages);
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("There are " + totalFkRefs + " foreign key refs in the database"));
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting fk reference meta data Error was:" + sqle.toString() + ". Not checking fk refs.", messages);
            refInfo = null;
        }
        finally {
            this.cleanup(connection, messages);
        }
        return refInfo;
    }

    public Map getIndexInfo(Set tableNames, Collection messages) {
        return this.getIndexInfo(tableNames, messages, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getIndexInfo(Set tableNames, Collection messages, boolean includeUnique) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to esablish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to esablish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database meta data... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Index Info From Database");
        }
        HashMap indexInfo = new HashMap();
        try {
            int totalIndices = 0;
            Iterator tableNamesIter = tableNames.iterator();
            String lookupSchemaName = this.lookupSchemaName(dbData);
            while (tableNamesIter.hasNext()) {
                String curTableName = (String)tableNamesIter.next();
                ResultSet rsCols = null;
                try {
                    rsCols = DatabaseTypeFactory.ORACLE_10G == DatabaseTypeFactory.getTypeForConnection(connection) || DatabaseTypeFactory.ORACLE_8I == DatabaseTypeFactory.getTypeForConnection(connection) ? dbData.getIndexInfo(null, lookupSchemaName, curTableName.toUpperCase(), false, true) : dbData.getIndexInfo(null, lookupSchemaName, curTableName, false, true);
                }
                catch (Exception e) {
                    Debug.logWarning((Throwable)e, (String)("Error getting index info for table: " + curTableName + " using lookupSchemaName " + lookupSchemaName));
                }
                while (rsCols != null && rsCols.next()) {
                    try {
                        if (rsCols.getShort("TYPE") == 0 || !includeUnique && !rsCols.getBoolean("NON_UNIQUE")) continue;
                        String indexName = rsCols.getString("INDEX_NAME");
                        indexName = indexName == null ? null : indexName.toUpperCase();
                        TreeSet<String> tableIndexList = (TreeSet<String>)indexInfo.get(curTableName);
                        if (tableIndexList == null) {
                            tableIndexList = new TreeSet<String>();
                            indexInfo.put(curTableName, tableIndexList);
                            if (Debug.verboseOn()) {
                                Debug.logVerbose((String)("Adding new Map for table: " + curTableName));
                            }
                        }
                        if (!tableIndexList.contains(indexName)) {
                            ++totalIndices;
                        }
                        tableIndexList.add(indexName);
                    }
                    catch (SQLException sqle) {
                        this.error("Error getting fk reference info for table. Error was:" + sqle.toString(), messages);
                    }
                }
                if (rsCols == null) continue;
                try {
                    rsCols.close();
                }
                catch (SQLException sqle) {
                    this.error("Unable to close ResultSet for fk reference list, continuing anyway... Error was:" + sqle.toString(), messages);
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("There are " + totalIndices + " indices in the database"));
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting fk reference meta data Error was:" + sqle.toString() + ". Not checking fk refs.", messages);
            indexInfo = null;
        }
        finally {
            this.cleanup(connection, messages);
        }
        return indexInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTable(ModelEntity entity, Map modelEntities, boolean addFks, boolean usePkConstraintNames, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        if (entity == null) {
            return "ModelEntity was null and is required to create a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create table for a view entity";
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        StringBuffer sqlBuf = new StringBuffer("CREATE TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" (");
        for (int i = 0; i < entity.getFieldsSize(); ++i) {
            ModelField field = entity.getField(i);
            ModelFieldType type = this.modelFieldTypeReader.getModelFieldType(field.getType());
            if (type == null) {
                return "Field type [" + type + "] not found for field [" + field.getName() + "] of entity [" + entity.getEntityName() + "], not creating table.";
            }
            sqlBuf.append(field.getColName());
            sqlBuf.append(" ");
            sqlBuf.append(type.getSqlType());
            if (field.getIsPk()) {
                sqlBuf.append(" NOT NULL, ");
                continue;
            }
            sqlBuf.append(", ");
        }
        String pkName = "PK_" + entity.getPlainTableName();
        if (pkName.length() > constraintNameClipLength) {
            pkName = pkName.substring(0, constraintNameClipLength);
        }
        if (usePkConstraintNames) {
            sqlBuf.append("CONSTRAINT ");
            sqlBuf.append(pkName);
        }
        sqlBuf.append(" PRIMARY KEY (");
        sqlBuf.append(entity.colNameString(entity.getPksCopy()));
        sqlBuf.append(")");
        if (addFks) {
            Iterator relationsIter = entity.getRelationsIterator();
            while (relationsIter.hasNext()) {
                ModelRelation modelRelation = (ModelRelation)relationsIter.next();
                if (!"one".equals(modelRelation.getType())) continue;
                ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
                if (relModelEntity == null) {
                    Debug.logError((String)("Error adding foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                    continue;
                }
                if (relModelEntity instanceof ModelViewEntity) {
                    Debug.logError((String)("Error adding foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                    continue;
                }
                sqlBuf.append(", ");
                sqlBuf.append(this.makeFkConstraintClause(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred));
            }
        }
        sqlBuf.append(")");
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createTable] sql=" + sqlBuf.toString()));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addColumn(ModelEntity entity, ModelField field) {
        if (entity == null || field == null) {
            return "ModelEntity or ModelField where null, cannot add column";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot add column for a view entity";
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        ModelFieldType type = this.modelFieldTypeReader.getModelFieldType(field.getType());
        if (type == null) {
            return "Field type [" + type + "] not found for field [" + field.getName() + "] of entity [" + entity.getEntityName() + "], not adding column.";
        }
        StringBuffer sqlBuf = new StringBuffer("ALTER TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" ADD ");
        sqlBuf.append(field.getColName());
        sqlBuf.append(" ");
        sqlBuf.append(type.getSqlType());
        String sql = sqlBuf.toString();
        if (Debug.infoOn()) {
            Debug.logInfo((String)("[addColumn] sql=" + sql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            String sql2 = "ALTER TABLE " + entity.getTableName(this.datasourceInfo) + " ADD COLUMN " + field.getColName() + " " + type.getSqlType();
            if (Debug.infoOn()) {
                Debug.logInfo((String)("[addColumn] sql failed, trying sql2=" + sql2));
            }
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(sql2);
            }
            catch (SQLException sqle2) {
                String string = "SQL Exception while executing the following:\n" + sql + "\nError was: " + sqle.toString();
                return string;
            }
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeFkConstraintName(ModelRelation modelRelation, int constraintNameClipLength) {
        String relConstraintName = modelRelation.getFkName();
        if (relConstraintName == null || relConstraintName.length() == 0) {
            relConstraintName = modelRelation.getTitle() + modelRelation.getRelEntityName();
            relConstraintName = relConstraintName.toUpperCase();
        }
        if (relConstraintName.length() > constraintNameClipLength) {
            relConstraintName = relConstraintName.substring(0, constraintNameClipLength);
        }
        return relConstraintName;
    }

    public String createForeignKeys(ModelEntity entity, Map modelEntities, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        if (entity == null) {
            return "ModelEntity was null and is required to create foreign keys for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create foreign keys for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType())) continue;
            ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
            if (relModelEntity == null) {
                Debug.logError((String)("Error adding foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            if (relModelEntity instanceof ModelViewEntity) {
                Debug.logError((String)("Error adding foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            String retMsg = this.createForeignKey(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createForeignKey(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        StringBuffer sqlBuf = new StringBuffer("ALTER TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" ADD ");
        sqlBuf.append(this.makeFkConstraintClause(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred));
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createForeignKey] sql=" + sqlBuf.toString()));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeFkConstraintClause(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        String relConstraintName;
        Iterator keyMapsIter = modelRelation.getKeyMapsIterator();
        StringBuffer mainCols = new StringBuffer();
        StringBuffer relCols = new StringBuffer();
        while (keyMapsIter.hasNext()) {
            ModelKeyMap keyMap = (ModelKeyMap)keyMapsIter.next();
            ModelField mainField = entity.getField(keyMap.getFieldName());
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
            ModelField relField = relModelEntity.getField(keyMap.getRelFieldName());
            if (relCols.length() > 0) {
                relCols.append(", ");
            }
            relCols.append(relField.getColName());
        }
        StringBuffer sqlBuf = new StringBuffer("");
        if ("name_constraint".equals(fkStyle)) {
            sqlBuf.append("CONSTRAINT ");
            relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            sqlBuf.append(relConstraintName);
            sqlBuf.append(" FOREIGN KEY (");
            sqlBuf.append(mainCols.toString());
            sqlBuf.append(") REFERENCES ");
            sqlBuf.append(relModelEntity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            sqlBuf.append(relCols.toString());
            sqlBuf.append(")");
            if (useFkInitiallyDeferred) {
                sqlBuf.append(" INITIALLY DEFERRED");
            }
        } else if ("name_fk".equals(fkStyle)) {
            sqlBuf.append(" FOREIGN KEY ");
            relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            sqlBuf.append(relConstraintName);
            sqlBuf.append(" (");
            sqlBuf.append(mainCols.toString());
            sqlBuf.append(") REFERENCES ");
            sqlBuf.append(relModelEntity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            sqlBuf.append(relCols.toString());
            sqlBuf.append(")");
            if (useFkInitiallyDeferred) {
                sqlBuf.append(" INITIALLY DEFERRED");
            }
        } else {
            String emsg = "ERROR: fk-style specified for this data-source is not valid: " + fkStyle;
            Debug.logError((String)emsg);
            throw new IllegalArgumentException(emsg);
        }
        return sqlBuf.toString();
    }

    public String deleteForeignKeys(ModelEntity entity, Map modelEntities, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys for a view entity";
        }
        Iterator relationsIter = entity.getRelationsIterator();
        StringBuffer retMsgsBuffer = new StringBuffer();
        while (relationsIter.hasNext()) {
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType())) continue;
            ModelEntity relModelEntity = (ModelEntity)modelEntities.get(modelRelation.getRelEntityName());
            if (relModelEntity == null) {
                Debug.logError((String)("Error removing foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            if (relModelEntity instanceof ModelViewEntity) {
                Debug.logError((String)("Error removing foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            String retMsg = this.deleteForeignKey(entity, modelRelation, relModelEntity, constraintNameClipLength);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteForeignKey(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        StringBuffer sqlBuf = new StringBuffer("ALTER TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" DROP CONSTRAINT ");
        sqlBuf.append(relConstraintName);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[deleteForeignKey] sql=" + sqlBuf.toString()));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String createDeclaredIndices(ModelEntity entity) {
        if (entity == null) {
            return "ModelEntity was null and is required to create declared indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create declared indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator indexesIter = entity.getIndexesIterator();
        while (indexesIter.hasNext()) {
            ModelIndex modelIndex = (ModelIndex)indexesIter.next();
            String retMsg = this.createDeclaredIndex(entity, modelIndex);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDeclaredIndex(ModelEntity entity, ModelIndex modelIndex) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        String createIndexSql = this.makeIndexClause(entity, modelIndex);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createForeignKeyIndex] index sql=" + createIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + createIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeIndexClause(ModelEntity entity, ModelIndex modelIndex) {
        Iterator fieldNamesIter = modelIndex.getIndexFieldsIterator();
        StringBuffer mainCols = new StringBuffer();
        while (fieldNamesIter.hasNext()) {
            String fieldName = (String)fieldNamesIter.next();
            ModelField mainField = entity.getField(fieldName);
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
        }
        StringBuffer indexSqlBuf = new StringBuffer("CREATE ");
        if (modelIndex.getUnique()) {
            indexSqlBuf.append("UNIQUE ");
        }
        indexSqlBuf.append("INDEX ");
        indexSqlBuf.append(modelIndex.getName());
        indexSqlBuf.append(" ON ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(" (");
        indexSqlBuf.append(mainCols.toString());
        indexSqlBuf.append(")");
        return indexSqlBuf.toString();
    }

    public String deleteDeclaredIndices(ModelEntity entity) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator indexesIter = entity.getIndexesIterator();
        while (indexesIter.hasNext()) {
            ModelIndex modelIndex = (ModelIndex)indexesIter.next();
            String retMsg = this.deleteDeclaredIndex(entity, modelIndex);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteDeclaredIndex(ModelEntity entity, ModelIndex modelIndex) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        StringBuffer indexSqlBuf = new StringBuffer("DROP INDEX ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(".");
        indexSqlBuf.append(modelIndex.getName());
        String deleteIndexSql = indexSqlBuf.toString();
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[deleteForeignKeyIndex] index sql=" + deleteIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(deleteIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + deleteIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String createForeignKeyIndices(ModelEntity entity, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to create foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create foreign keys indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            String retMsg;
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType()) || (retMsg = this.createForeignKeyIndex(entity, modelRelation, constraintNameClipLength)) == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createForeignKeyIndex(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        String createIndexSql = this.makeFkIndexClause(entity, modelRelation, constraintNameClipLength);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createForeignKeyIndex] index sql=" + createIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + createIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeFkIndexClause(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Iterator keyMapsIter = modelRelation.getKeyMapsIterator();
        StringBuffer mainCols = new StringBuffer();
        while (keyMapsIter.hasNext()) {
            ModelKeyMap keyMap = (ModelKeyMap)keyMapsIter.next();
            ModelField mainField = entity.getField(keyMap.getFieldName());
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
        }
        StringBuffer indexSqlBuf = new StringBuffer("CREATE INDEX ");
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        indexSqlBuf.append(relConstraintName);
        indexSqlBuf.append(" ON ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(" (");
        indexSqlBuf.append(mainCols.toString());
        indexSqlBuf.append(")");
        return indexSqlBuf.toString();
    }

    public String deleteForeignKeyIndices(ModelEntity entity, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys indices for a view entity";
        }
        StringBuffer retMsgsBuffer = new StringBuffer();
        Iterator relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            String retMsg;
            ModelRelation modelRelation = (ModelRelation)relationsIter.next();
            if (!"one".equals(modelRelation.getType()) || (retMsg = this.deleteForeignKeyIndex(entity, modelRelation, constraintNameClipLength)) == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteForeignKeyIndex(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to esablish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to esablish a connection with the database... Error was: " + e.toString();
        }
        StringBuffer indexSqlBuf = new StringBuffer("DROP INDEX ");
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(".");
        indexSqlBuf.append(relConstraintName);
        String deleteIndexSql = indexSqlBuf.toString();
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[deleteForeignKeyIndex] index sql=" + deleteIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(deleteIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + deleteIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    private String convertToSchemaTableName(String tableName, DatabaseMetaData dbData) throws SQLException {
        if (tableName != null && dbData.supportsSchemasInTableDefinitions() && this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 && !tableName.startsWith(this.datasourceInfo.getSchemaName())) {
            return this.datasourceInfo.getSchemaName().toUpperCase() + "." + tableName;
        }
        return tableName;
    }

    private void logDbInfo(DatabaseMetaData dbData) {
        try {
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Product Name is " + dbData.getDatabaseProductName()), (String)module);
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Product Version is " + dbData.getDatabaseProductVersion()), (String)module);
            }
        }
        catch (SQLException sqle) {
            Debug.logWarning((String)"Unable to get Database name & version information", (String)module);
        }
        try {
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Driver Name is " + dbData.getDriverName()), (String)module);
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Driver Version is " + dbData.getDriverVersion()), (String)module);
            }
        }
        catch (SQLException sqle) {
            Debug.logWarning((String)"Unable to get Driver name & version information", (String)module);
        }
    }

    private void cleanup(Connection connection, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void cleanup(Connection connection, Collection messages) {
        try {
            connection.close();
        }
        catch (SQLException sqle2) {
            this.error("Unable to close database connection, continuing anyway... Error was:" + sqle2.toString(), messages);
        }
    }

    void error(String message, Collection messages) {
        Debug.logError((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    void warn(String message, Collection messages) {
        Debug.logWarning((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    void important(String message, Collection messages) {
        Debug.logImportant((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    void verbose(String message, Collection messages) {
        Debug.logVerbose((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    public static class ReferenceCheckInfo {
        public String pkTableName;
        public String pkColumnName;
        public String fkName;
        public String fkTableName;
        public String fkColumnName;

        public String toString() {
            return "FK Reference from table " + this.fkTableName + " called " + this.fkName + " to PK in table " + this.pkTableName;
        }
    }

    public static class ColumnCheckInfo {
        public String tableName;
        public String columnName;
        public String typeName;
        public int columnSize;
        public int decimalDigits;
        public String isNullable;
    }
}

