/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.util.UtilValidate;

public class GenericValue
extends GenericEntity {
    public transient Map relatedCache = null;
    public transient Map relatedOneCache = null;
    protected Map originalDbValues = null;

    public GenericValue(ModelEntity modelEntity) {
        super(modelEntity);
    }

    public GenericValue(ModelEntity modelEntity, Map fields) {
        super(modelEntity, fields);
    }

    public GenericValue(GenericValue value) {
        super(value);
    }

    public GenericValue(GenericPK primaryKey) {
        super(primaryKey);
    }

    public GenericValue create() throws GenericEntityException {
        return this.getDelegator().create(this);
    }

    public void store() throws GenericEntityException {
        this.getDelegator().store(this);
    }

    public void remove() throws GenericEntityException {
        this.getDelegator().removeValue(this);
    }

    public void refresh() throws GenericEntityException {
        this.getDelegator().refresh(this);
    }

    public boolean originalDbValuesAvailable() {
        return this.originalDbValues != null;
    }

    public Object getOriginalDbValue(String name) {
        if (this.getModelEntity().getField(name) == null) {
            throw new IllegalArgumentException("[GenericEntity.get] \"" + name + "\" is not a field of " + this.entityName);
        }
        return this.originalDbValues.get(name);
    }

    public void copyOriginalDbValues() {
        this.originalDbValues = new HashMap(this.fields);
    }

    public List getRelated(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelated(relationName, this);
    }

    public List getRelated(String relationName, Map byAndFields, List orderBy) throws GenericEntityException {
        return this.getDelegator().getRelated(relationName, byAndFields, orderBy, this);
    }

    public List getRelatedCache(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedCache(relationName, this);
    }

    public List getRelatedMulti(String relationNameOne, String relationNameTwo, List orderBy) throws GenericEntityException {
        return this.getDelegator().getMultiRelation(this, relationNameOne, relationNameTwo, orderBy);
    }

    public List getRelatedMulti(String relationNameOne, String relationNameTwo) throws GenericEntityException {
        return this.getDelegator().getMultiRelation(this, relationNameOne, relationNameTwo, null);
    }

    public List getRelatedCache(String relationName, Map byAndFields, List orderBy) throws GenericEntityException {
        List col = this.getRelatedCache(relationName);
        if (byAndFields != null) {
            col = EntityUtil.filterByAnd(col, byAndFields);
        }
        if (UtilValidate.isNotEmpty((Collection)orderBy)) {
            col = EntityUtil.orderBy(col, orderBy);
        }
        return col;
    }

    public List getRelatedEmbeddedCache(String relationName) throws GenericEntityException {
        List col;
        if (this.relatedCache == null) {
            this.relatedCache = new Hashtable();
        }
        if ((col = (List)this.relatedCache.get(relationName)) == null) {
            col = this.getRelated(relationName);
            this.relatedCache.put(relationName, col);
        }
        return col;
    }

    public List getRelatedEmbeddedCache(String relationName, Map byAndFields, List orderBy) throws GenericEntityException {
        List col = this.getRelatedEmbeddedCache(relationName);
        if (byAndFields != null) {
            col = EntityUtil.filterByAnd(col, byAndFields);
        }
        if (UtilValidate.isNotEmpty((Collection)orderBy)) {
            col = EntityUtil.orderBy(col, orderBy);
        }
        return col;
    }

    public GenericValue getRelatedOne(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedOne(relationName, this);
    }

    public GenericValue getRelatedOneCache(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedOneCache(relationName, this);
    }

    public GenericValue getRelatedOneEmbeddedCache(String relationName) throws GenericEntityException {
        GenericValue value;
        if (this.relatedOneCache == null) {
            this.relatedOneCache = new Hashtable();
        }
        if ((value = (GenericValue)this.relatedOneCache.get(relationName)) == null && (value = this.getRelatedOne(relationName)) != null) {
            this.relatedOneCache.put(relationName, value);
        }
        return value;
    }

    public List getRelatedByAnd(String relationName, Map fields) throws GenericEntityException {
        return this.getDelegator().getRelatedByAnd(relationName, fields, this);
    }

    public List getRelatedByAndCache(String relationName, Map fields) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getDelegator().getRelatedCache(relationName, this), fields);
    }

    public List getRelatedByAndEmbeddedCache(String relationName, Map fields) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getRelatedEmbeddedCache(relationName), fields);
    }

    public List getRelatedOrderBy(String relationName, List orderBy) throws GenericEntityException {
        return this.getDelegator().getRelatedOrderBy(relationName, orderBy, this);
    }

    public List getRelatedOrderByCache(String relationName, List orderBy) throws GenericEntityException {
        return EntityUtil.orderBy(this.getDelegator().getRelatedCache(relationName, this), orderBy);
    }

    public List getRelatedOrderByEmbeddedCache(String relationName, List orderBy) throws GenericEntityException {
        return EntityUtil.orderBy(this.getRelatedEmbeddedCache(relationName), orderBy);
    }

    public void removeRelated(String relationName) throws GenericEntityException {
        this.getDelegator().removeRelated(relationName, this);
    }

    public GenericPK getRelatedDummyPK(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedDummyPK(relationName, null, this);
    }

    public GenericPK getRelatedDummyPK(String relationName, Map byAndFields) throws GenericEntityException {
        return this.getDelegator().getRelatedDummyPK(relationName, byAndFields, this);
    }

    public Object clone() {
        GenericValue newEntity = new GenericValue(this);
        newEntity.setDelegator(this.internalDelegator);
        return newEntity;
    }
}

