/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;

public class EntityFieldMap
extends EntityCondition {
    protected Map fieldMap;
    protected EntityOperator operator;

    protected EntityFieldMap() {
    }

    public EntityFieldMap(Map fieldMap, EntityOperator operator) {
        this.fieldMap = fieldMap;
        this.operator = operator;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public Object getField(String name) {
        return this.fieldMap.get(name);
    }

    public boolean containsField(String name) {
        return this.fieldMap.containsKey(name);
    }

    public Iterator getFieldKeyIterator() {
        return this.fieldMap.keySet().iterator();
    }

    public Iterator getFieldEntryIterator() {
        return this.fieldMap.entrySet().iterator();
    }

    public String makeWhereString(ModelEntity modelEntity, List entityConditionParams) {
        ArrayList<ModelField> whereFields = new ArrayList<ModelField>();
        if (this.fieldMap != null && this.fieldMap.size() > 0) {
            for (int fi = 0; fi < modelEntity.getFieldsSize(); ++fi) {
                ModelField curField = modelEntity.getField(fi);
                if (!this.fieldMap.containsKey(curField.getName())) continue;
                whereFields.add(curField);
            }
        }
        return SqlJdbcUtil.makeWhereStringFromFields(whereFields, this.fieldMap, this.operator.getCode(), entityConditionParams);
    }

    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        if (this.fieldMap != null && !modelEntity.areFields(this.fieldMap.keySet())) {
            throw new GenericModelException("At least one of the passed fields is not valid: " + this.fieldMap.keySet().toString());
        }
    }

    public String toString() {
        return "[FieldMap::" + this.operator + "::" + this.fieldMap + "]";
    }
}

