/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public abstract class AbstractDatabaseType
implements DatabaseType {
    private final String name;
    protected static final String CHANGE_COLUMN_TYPE_CLAUSE_STRUCTURE_STANDARD_ALTER_COLUMN = "ALTER TABLE {0} ALTER COLUMN {1} {2}";
    protected static final String CHANGE_COLUMN_TYPE_CLAUSE_STRUCTURE_STANDARD_MODIFY = "ALTER TABLE {0} MODIFY {1} {2}";
    private final String fieldTypeName;
    private final String[] productNamePrefix;
    private final int constraintNameClipLength;
    private static final int STANDARD_CONSTRAINT_NAME_CLIP_LENGTH = 30;

    protected AbstractDatabaseType(String name, String fieldTypeName, String[] productNamePrefix, int constraintNameClipLength) {
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.productNamePrefix = productNamePrefix;
        this.constraintNameClipLength = constraintNameClipLength;
        this.registerWithFactory();
    }

    protected AbstractDatabaseType(String name, String fieldTypeName, String[] productNamePrefix) {
        this(name, fieldTypeName, productNamePrefix, 30);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public String toString() {
        return this.name;
    }

    public String[] getProductNamePrefix() {
        return this.productNamePrefix;
    }

    @Override
    public String getSchemaName(Connection con) {
        return null;
    }

    @Override
    public int getConstraintNameClipLength() {
        return this.constraintNameClipLength;
    }

    @Override
    public abstract boolean matchesConnection(Connection var1) throws SQLException;

    protected void registerWithFactory() {
        DatabaseTypeFactory.registerDatabaseType(this);
    }

    protected static boolean versionGreaterThanOrEqual(int major1, int minor1, int major2, int minor2) {
        return major1 > major2 || major1 == major2 && minor1 >= minor2;
    }

    protected static boolean productNamesMatch(String productNamePrefix, String testName) {
        return testName != null && testName.length() >= productNamePrefix.length() && testName.substring(0, productNamePrefix.length()).equalsIgnoreCase(productNamePrefix);
    }

    protected static boolean isProductNameInPrefixList(String[] productNamePrefixes, String productName) {
        if (productName != null) {
            for (int i = 0; i < productNamePrefixes.length; ++i) {
                if (!AbstractDatabaseType.productNamesMatch(productNamePrefixes[i], productName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean productNameMatches(Connection con) throws SQLException {
        String productName = con.getMetaData().getDatabaseProductName();
        return productName != null && AbstractDatabaseType.isProductNameInPrefixList(this.productNamePrefix, productName.trim());
    }

    protected boolean versionGreaterThanOrEqual(Connection con, int majorVersion, int minorVersion) throws SQLException {
        try {
            DatabaseMetaData metaData = con.getMetaData();
            return AbstractDatabaseType.versionGreaterThanOrEqual(metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), majorVersion, minorVersion);
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    protected boolean versionLessThanOrEqual(Connection con, int majorVersion, int minorVersion) throws SQLException {
        try {
            DatabaseMetaData metaData = con.getMetaData();
            return AbstractDatabaseType.versionGreaterThanOrEqual(majorVersion, minorVersion, metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    protected String getChangeColumnTypeStructure() {
        return null;
    }

    @Override
    public final String getChangeColumnTypeSQL(String tableName, String columnName, String targetSqlType) {
        String clauseStructure = this.getChangeColumnTypeStructure();
        return clauseStructure == null ? null : MessageFormat.format(clauseStructure, tableName, columnName, targetSqlType);
    }
}

