/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.util.Debug;
import tyrex.resource.jdbc.xa.EnabledDataSource;

public class TyrexConnectionFactory {
    protected static Map<String, EnabledDataSource> dsCache = CopyOnWriteMap.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        EnabledDataSource ds = dsCache.get(helperName);
        if (ds != null) {
            return TransactionUtil.enlistConnection(ds.getXAConnection());
        }
        Class<TyrexConnectionFactory> clazz = TyrexConnectionFactory.class;
        synchronized (TyrexConnectionFactory.class) {
            ds = dsCache.get(helperName);
            if (ds != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return TransactionUtil.enlistConnection(ds.getXAConnection());
            }
            ds = new EnabledDataSource();
            ds.setDriverClassName(jdbcDatasource.getDriverClassName());
            ds.setDriverName(jdbcDatasource.getUri());
            ds.setUser(jdbcDatasource.getUsername());
            ds.setPassword(jdbcDatasource.getPassword());
            ds.setDescription(helperName);
            String transIso = jdbcDatasource.getIsolationLevel();
            if (transIso != null && transIso.length() > 0) {
                ds.setIsolationLevel(transIso);
            }
            ds.setLogWriter(Debug.getPrintWriter());
            dsCache.put(helperName, ds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return TransactionUtil.enlistConnection(ds.getXAConnection());
        }
    }
}

