/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.objectweb.jotm.Jotm;
import org.objectweb.transaction.jta.TMService;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.JotmConnectionFactory;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.util.Debug;

public class JotmFactory
implements TransactionFactoryInterface {
    public static final String module = JotmFactory.class.getName();
    private static TMService jotm;

    public TransactionManager getTransactionManager() {
        if (jotm != null) {
            return jotm.getTransactionManager();
        }
        Debug.logError((String)"Cannot get TransactionManager, JOTM object is null", (String)module);
        return null;
    }

    public UserTransaction getUserTransaction() {
        if (jotm != null) {
            return jotm.getUserTransaction();
        }
        Debug.logError((String)"Cannot get UserTransaction, JOTM object is null", (String)module);
        return null;
    }

    public String getTxMgrName() {
        return "jotm";
    }

    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        if (datasourceInfo.getJdbcDatasource() != null) {
            try {
                Connection con = JotmConnectionFactory.getConnection(helperName, datasourceInfo.getJdbcDatasource());
                if (con != null) {
                    return con;
                }
            }
            catch (Exception ex) {
                Debug.logError((Throwable)ex, (String)("JOTM is the configured transaction manager but there was an error getting a database Connection through JOTM for the " + helperName + " datasource. Please check your configuration, class path, etc."));
            }
            Connection otherCon = ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.getJdbcDatasource());
            return otherCon;
        }
        Debug.logError((String)("JOTM is the configured transaction manager but no inline-jdbc element was specified in the " + helperName + " datasource. Please check your configuration"));
        return null;
    }

    public void removeDatasource(String helperName) {
        try {
            JotmConnectionFactory.removeDatasource(helperName);
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)("Error shutting down the JOTM " + helperName + " datasource. Please check your configuration, class path, etc."));
            ConnectionFactory.removeDatasource(helperName);
        }
    }

    static {
        try {
            jotm = new Jotm(true, false);
        }
        catch (NamingException ne) {
            Debug.logError((Throwable)ne, (String)"Problems creating JOTM instance", (String)module);
        }
    }
}

