/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.entity.GenericEntityConfException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelGroupReader {
    public static UtilCache readers = new UtilCache("entity.ModelGroupReader", 0L, 0L);
    private Map groupCache = null;
    private Set groupNames = null;
    public String modelName;
    public ResourceHandler entityGroupResourceHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelGroupReader getModelGroupReader(String delegatorName) throws GenericEntityConfException {
        EntityConfigUtil.DelegatorInfo delegatorInfo = EntityConfigUtil.getInstance().getDelegatorInfo(delegatorName);
        if (delegatorInfo == null) {
            throw new GenericEntityConfException("Could not find a delegator with the name " + delegatorName);
        }
        String tempModelName = delegatorInfo.entityGroupReader;
        ModelGroupReader reader = (ModelGroupReader)readers.get((Object)tempModelName);
        if (reader != null) return reader;
        Class<ModelGroupReader> clazz = ModelGroupReader.class;
        synchronized (ModelGroupReader.class) {
            reader = (ModelGroupReader)readers.get((Object)tempModelName);
            if (reader != null) return reader;
            reader = new ModelGroupReader(tempModelName);
            readers.put((Object)tempModelName, (Object)reader);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return reader;
        }
    }

    public ModelGroupReader(String modelName) throws GenericEntityConfException {
        this.modelName = modelName;
        EntityConfigUtil.EntityGroupReaderInfo entityGroupReaderInfo = EntityConfigUtil.getInstance().getEntityGroupReaderInfo(modelName);
        if (entityGroupReaderInfo == null) {
            throw new GenericEntityConfException("Cound not find an entity-group-reader with the name " + modelName);
        }
        this.entityGroupResourceHandler = new ResourceHandler("entityengine.xml", entityGroupReaderInfo.resourceElement);
        this.getGroupCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getGroupCache() {
        if (this.groupCache != null) return this.groupCache;
        Class<ModelGroupReader> clazz = ModelGroupReader.class;
        synchronized (ModelGroupReader.class) {
            if (this.groupCache != null) return this.groupCache;
            this.groupCache = new HashMap();
            this.groupNames = new TreeSet();
            UtilTimer utilTimer = new UtilTimer();
            Document document = null;
            try {
                document = this.entityGroupResourceHandler.getDocument();
            }
            catch (GenericConfigException e) {
                Debug.logError((Throwable)e, (String)"Error loading entity group model");
            }
            if (document == null) {
                this.groupCache = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            Hashtable docElementValues = null;
            docElementValues = new Hashtable();
            Element docElement = document.getDocumentElement();
            if (docElement == null) {
                this.groupCache = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            docElement.normalize();
            Node curChild = docElement.getFirstChild();
            int i = 0;
            if (curChild != null) {
                utilTimer.timerString("[ModelGroupReader.getGroupCache] Before start of entity loop");
                do {
                    if (curChild.getNodeType() != 1 || !"entity-group".equals(curChild.getNodeName())) continue;
                    Element curEntity = (Element)curChild;
                    String entityName = UtilXml.checkEmpty((String)curEntity.getAttribute("entity"));
                    String groupName = UtilXml.checkEmpty((String)curEntity.getAttribute("group"));
                    if (groupName == null || entityName == null) continue;
                    this.groupNames.add(groupName);
                    this.groupCache.put(entityName, groupName);
                    ++i;
                } while ((curChild = curChild.getNextSibling()) != null);
            } else {
                Debug.logWarning((String)"[ModelGroupReader.getGroupCache] No child nodes found.");
            }
            utilTimer.timerString("[ModelGroupReader.getGroupCache] FINISHED - Total Entity-Groups: " + i + " FINISHED");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.groupCache;
        }
    }

    public String getEntityGroupName(String entityName) {
        Map gc = this.getGroupCache();
        if (gc != null) {
            return (String)gc.get(entityName);
        }
        return null;
    }

    public Collection getGroupNames() {
        this.getGroupCache();
        if (this.groupNames == null) {
            return null;
        }
        return new ArrayList(this.groupNames);
    }

    public Collection getEntityNamesByGroup(String groupName) {
        Map gc = this.getGroupCache();
        LinkedList enames = new LinkedList();
        if (groupName == null || groupName.length() <= 0) {
            return enames;
        }
        if (gc == null || gc.size() < 0) {
            return enames;
        }
        Set gcEntries = gc.entrySet();
        for (Map.Entry entry : gcEntries) {
            if (!groupName.equals(entry.getValue())) continue;
            enames.add(entry.getKey());
        }
        return enames;
    }
}

