/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractDatabaseType;
import org.ofbiz.core.util.Debug;

public class SapDB76DatabaseType
extends AbstractDatabaseType {
    public SapDB76DatabaseType() {
        super("SAP DB Version 7.6 or greater", "sapdb", new String[]{"SAP DB"});
    }

    public boolean matchesConnection(Connection con) throws SQLException {
        return this.productNameMatches(con) && this.versionGreaterThanOrEqual(con, 7, 6);
    }

    public String getSchemaName(Connection con) {
        try {
            DatabaseMetaData metaData = con.getMetaData();
            return metaData.getUserName().toUpperCase();
        }
        catch (SQLException e) {
            Debug.logError((Throwable)e, (String)"Exception occured while trying to find the schema name for the database connection to a DB2 database");
            return null;
        }
    }
}

