/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractDatabaseType;

public abstract class AbstractPostgresDatabaseType
extends AbstractDatabaseType {
    private static final int MAJOR = 0;
    private static final int MINOR = 1;

    protected AbstractPostgresDatabaseType(String name, String fieldTypeName) {
        super(name, fieldTypeName, new String[]{"POSTGRESQL"});
    }

    public String getSchemaName(Connection con) {
        return "public";
    }

    protected int[] parseVersionStr(String version) {
        int[] versionNumber = new int[2];
        StringTokenizer versionTokens = new StringTokenizer(version, ".");
        if (versionTokens.hasMoreElements()) {
            versionNumber[0] = Integer.parseInt(versionTokens.nextToken());
            if (versionTokens.hasMoreElements()) {
                versionNumber[1] = Integer.parseInt(versionTokens.nextToken());
                return versionNumber;
            }
        }
        return null;
    }

    protected int[] getPostgresVersion(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        try {
            int[] versionNumber = new int[]{metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion()};
            return versionNumber;
        }
        catch (AbstractMethodError ame) {
            return this.parseVersionStr(metaData.getDatabaseProductVersion());
        }
    }

    protected boolean postgresVersionGreaterThanOrEqual(Connection con, int major, int minor) throws SQLException {
        int[] vers = this.getPostgresVersion(con);
        return AbstractPostgresDatabaseType.versionGreaterThanOrEqual(vers[0], vers[1], major, minor);
    }

    protected boolean postgresVersionLessThanOrEqual(Connection con, int major, int minor) throws SQLException {
        int[] vers = this.getPostgresVersion(con);
        return AbstractPostgresDatabaseType.versionGreaterThanOrEqual(major, minor, vers[0], vers[1]);
    }
}

