/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.transaction.DBCPConnectionFactory;
import org.ofbiz.core.util.Debug;

public class ConnectionFactory {
    public static final String module = ConnectionFactory.class.getName();

    public static Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        Connection con = TransactionFactory.getConnection(helperName);
        if (con == null) {
            Debug.logError((String)("******* ERROR: No database connection found for helperName \"" + helperName + "\""), (String)module);
        }
        return con;
    }

    public static Connection tryGenericConnectionSources(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        try {
            Connection con = DBCPConnectionFactory.getConnection(helperName, jdbcDatasource);
            if (con != null) {
                return con;
            }
        }
        catch (Exception ex) {
            Debug.logError((Throwable)ex, (String)"There was an error getting a DBCP datasource.");
        }
        String driverClassName = jdbcDatasource.getDriverClassName();
        if (driverClassName != null && driverClassName.length() > 0) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                loader.loadClass(driverClassName);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.logWarning((String)("Could not find JDBC driver class named " + driverClassName + ".\n"));
                Debug.logWarning((Throwable)cnfe);
                return null;
            }
            return DriverManager.getConnection(jdbcDatasource.getUri(), jdbcDatasource.getUsername(), jdbcDatasource.getPassword());
        }
        return null;
    }

    public static void removeDatasource(String helperName) {
        DBCPConnectionFactory.removeDatasource(helperName);
    }
}

