/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.FlexibleProperties;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilURL;

public class UtilProperties {
    public static UtilCache<Object, FlexibleProperties> resourceCache = new UtilCache("properties.UtilPropertiesResourceCache");
    public static UtilCache<URL, FlexibleProperties> urlCache = new UtilCache("properties.UtilPropertiesUrlCache");
    public static UtilCache<String, ResourceBundle> bundleLocaleCache = new UtilCache("properties.UtilPropertiesBundleLocaleCache");

    public static boolean propertyValueEquals(String resource, String name, String compareString) {
        String value = UtilProperties.getPropertyValue(resource, name);
        if (value == null) {
            return false;
        }
        return value.trim().equals(compareString);
    }

    public static boolean propertyValueEqualsIgnoreCase(String resource, String name, String compareString) {
        String value = UtilProperties.getPropertyValue(resource, name);
        if (value == null) {
            return false;
        }
        return value.trim().equalsIgnoreCase(compareString);
    }

    public static String getPropertyValue(String resource, String name, String defaultValue) {
        String value = UtilProperties.getPropertyValue(resource, name);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public static double getPropertyNumber(String resource, String name) {
        String str = UtilProperties.getPropertyValue(resource, name);
        double strValue = 0.0;
        try {
            strValue = Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return strValue;
    }

    public static String getPropertyValue(String resource, String name) {
        if (resource == null || resource.length() <= 0) {
            return "";
        }
        if (name == null || name.length() <= 0) {
            return "";
        }
        FlexibleProperties properties = resourceCache.get(resource);
        if (properties == null) {
            try {
                URL url = UtilURL.fromResource(resource);
                if (url == null) {
                    return "";
                }
                properties = FlexibleProperties.makeFlexibleProperties(url);
                resourceCache.put(resource, properties);
            }
            catch (MissingResourceException e) {
                Debug.log(e.getMessage());
            }
        }
        if (properties == null) {
            Debug.log("[UtilProperties.getPropertyValue] could not find resource: " + resource);
            return "";
        }
        String value = null;
        try {
            value = properties.getProperty(name);
        }
        catch (Exception e) {
            Debug.log(e.getMessage());
        }
        return value == null ? "" : value.trim();
    }

    public static Properties getProperties(String resource) {
        if (resource == null || resource.length() <= 0) {
            return null;
        }
        FlexibleProperties properties = resourceCache.get(resource);
        if (properties == null) {
            try {
                URL url = UtilURL.fromResource(resource);
                if (url == null) {
                    return null;
                }
                properties = FlexibleProperties.makeFlexibleProperties(url);
                resourceCache.put(resource, properties);
            }
            catch (MissingResourceException e) {
                Debug.log(e.getMessage());
            }
        }
        if (properties == null) {
            Debug.log("[UtilProperties.getProperties] could not find resource: " + resource);
            return null;
        }
        return properties;
    }

    public static Properties getProperties(URL url) {
        if (url == null) {
            return null;
        }
        FlexibleProperties properties = resourceCache.get(url);
        if (properties == null) {
            try {
                properties = FlexibleProperties.makeFlexibleProperties(url);
                resourceCache.put(url, properties);
            }
            catch (MissingResourceException e) {
                Debug.log(e.getMessage());
            }
        }
        if (properties == null) {
            Debug.log("[UtilProperties.getProperties] could not find resource: " + String.valueOf(url));
            return null;
        }
        return properties;
    }

    public static boolean propertyValueEquals(URL url, String name, String compareString) {
        String value = UtilProperties.getPropertyValue(url, name);
        if (value == null) {
            return false;
        }
        return value.trim().equals(compareString);
    }

    public static boolean propertyValueEqualsIgnoreCase(URL url, String name, String compareString) {
        String value = UtilProperties.getPropertyValue(url, name);
        if (value == null) {
            return false;
        }
        return value.trim().equalsIgnoreCase(compareString);
    }

    public static String getPropertyValue(URL url, String name, String defaultValue) {
        String value = UtilProperties.getPropertyValue(url, name);
        if (value == null || value.length() <= 0) {
            return defaultValue;
        }
        return value;
    }

    public static double getPropertyNumber(URL url, String name) {
        String str = UtilProperties.getPropertyValue(url, name);
        double strValue = 0.0;
        try {
            strValue = Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return strValue;
    }

    public static String getPropertyValue(URL url, String name) {
        if (url == null) {
            return "";
        }
        if (name == null || name.length() <= 0) {
            return "";
        }
        FlexibleProperties properties = urlCache.get(url);
        if (properties == null) {
            try {
                properties = FlexibleProperties.makeFlexibleProperties(url);
                urlCache.put(url, properties);
            }
            catch (MissingResourceException e) {
                Debug.log(e.getMessage());
            }
        }
        if (properties == null) {
            Debug.log("[UtilProperties.getPropertyValue] could not find resource: " + String.valueOf(url));
            return null;
        }
        String value = null;
        try {
            value = properties.getProperty(name);
        }
        catch (Exception e) {
            Debug.log(e.getMessage());
        }
        return value == null ? "" : value.trim();
    }

    public static String getSplitPropertyValue(URL url, String name) {
        if (url == null) {
            return "";
        }
        if (name == null || name.length() <= 0) {
            return "";
        }
        FlexibleProperties properties = urlCache.get(url);
        if (properties == null) {
            try {
                properties = FlexibleProperties.makeFlexibleProperties(url);
                urlCache.put(url, properties);
            }
            catch (MissingResourceException e) {
                Debug.log(e.getMessage());
            }
        }
        if (properties == null) {
            Debug.log("[UtilProperties.getPropertyValue] could not find resource: " + String.valueOf(url));
            return null;
        }
        String value = null;
        try {
            int curIdx = 1;
            String curName = null;
            while ((curName = properties.getProperty("name." + curIdx)) != null) {
                if (name.equals(curName)) {
                    value = properties.getProperty("value." + curIdx);
                    break;
                }
                ++curIdx;
            }
        }
        catch (Exception e) {
            Debug.log(e.getMessage());
        }
        return value == null ? "" : value.trim();
    }

    public static String getMessage(String resource, String name, Locale locale) {
        if (resource == null || resource.length() <= 0) {
            return "";
        }
        if (name == null || name.length() <= 0) {
            return "";
        }
        ResourceBundle bundle = UtilProperties.getResourceBundle(resource, locale);
        if (bundle == null) {
            return "";
        }
        String value = null;
        try {
            value = bundle.getString(name);
        }
        catch (Exception e) {
            Debug.log(e.getMessage());
        }
        return value == null ? "" : value.trim();
    }

    public static String getMessage(String resource, String name, Object[] arguments, Locale locale) {
        String value = UtilProperties.getMessage(resource, name, locale);
        if (value == null || value.length() == 0) {
            return "";
        }
        if (arguments != null && arguments.length > 0) {
            value = MessageFormat.format(value, arguments);
        }
        return value;
    }

    public static String getMessage(String resource, String name, List<?> arguments, Locale locale) {
        String value = UtilProperties.getMessage(resource, name, locale);
        if (value == null || value.length() == 0) {
            return "";
        }
        if (arguments != null && arguments.size() > 0) {
            value = MessageFormat.format(value, arguments.toArray());
        }
        return value;
    }

    public static ResourceBundle getResourceBundle(String resource, Locale locale) {
        String resourceCacheKey;
        ResourceBundle bundle;
        if (resource == null || resource.length() <= 0) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = bundleLocaleCache.get(resourceCacheKey = resource + "_" + locale.toString())) == null) {
            try {
                bundle = ResourceBundle.getBundle(resource, locale);
                bundleLocaleCache.put(resourceCacheKey, bundle);
            }
            catch (MissingResourceException e) {
                Debug.log(e, "[UtilProperties.getPropertyValue] could not find resource: " + resource + " for locale " + locale.toString());
                return null;
            }
        }
        if (bundle == null) {
            Debug.log("[UtilProperties.getPropertyValue] could not find resource: " + resource + " for locale " + locale.toString());
            return null;
        }
        return bundle;
    }

    public static Properties getProperties(String resource, Locale locale) {
        String localeString;
        String resourceLocale;
        FlexibleProperties properties;
        if (resource == null || resource.length() <= 0) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((properties = resourceCache.get(resourceLocale = resource + "_" + (localeString = locale.toString()))) == null) {
            try {
                URL url = UtilURL.fromResource(resourceLocale);
                properties = url == null ? (FlexibleProperties)UtilProperties.getProperties(resource) : FlexibleProperties.makeFlexibleProperties(url);
            }
            catch (MissingResourceException e) {
                Debug.log(e.getMessage());
            }
            resourceCache.put(resourceLocale, properties);
        }
        if (properties == null) {
            Debug.logInfo("[UtilProperties.getProperties] could not find resource: " + resource + ", locale: " + String.valueOf(locale));
        }
        return properties;
    }
}

