/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.util.FlexibleProperties;
import org.ofbiz.core.util.UtilURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Debug {
    private static final String NO_MODULE = "NoModule";
    public static final int ALWAYS = 0;
    public static final int VERBOSE = 1;
    public static final int TIMING = 2;
    public static final int INFO = 3;
    public static final int IMPORTANT = 4;
    public static final int WARNING = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    private static final String[] LEVEL_PROPS = new String[]{"", "print.verbose", "print.timing", "print.info", "print.important", "print.warning", "print.error", "print.fatal"};
    private static final MessageLogger[] LEVEL_LOGS = new MessageLogger[]{Logger::trace, Logger::debug, Logger::trace, Logger::info, Logger::info, Logger::warn, Logger::error, Logger::error};
    private static final Map<String, Integer> LEVEL_STRING_MAP = new HashMap<String, Integer>();
    private static final boolean[] LEVEL_ON_CACHE = new boolean[8];
    private static final Logger ROOT = LoggerFactory.getLogger((String)"ROOT");
    private static PrintStream printStream = System.out;
    private static PrintWriter printWriter = new PrintWriter(printStream);

    public static Logger getLogger(String module) {
        if (module != null && module.length() > 0) {
            return LoggerFactory.getLogger((String)module);
        }
        return ROOT;
    }

    public static PrintStream getPrintStream() {
        return printStream;
    }

    public static void setPrintStream(PrintStream printStream) {
        Debug.printStream = printStream;
        printWriter = new PrintWriter(printStream);
    }

    public static PrintWriter getPrintWriter() {
        return printWriter;
    }

    public static Integer getLevelFromString(String levelName) {
        if (levelName == null) {
            return null;
        }
        return LEVEL_STRING_MAP.get(levelName.toLowerCase());
    }

    public static int getLevelFromStringWithDefault(String levelName) {
        Integer levelInt = Debug.getLevelFromString(levelName);
        if (levelInt == null) {
            return 3;
        }
        return levelInt;
    }

    public static void log(int level, Throwable t, String msg, String module) {
        Debug.log(level, t, msg, module, "org.ofbiz.core.util.Debug");
    }

    public static void log(int level, Throwable t, String msg, String module, String callingClass) {
        Debug.log(level, t, msg, module, callingClass, new Object[0]);
    }

    public static void log(int level, Throwable t, String msg, String module, String callingClass, Object ... params) {
        if (Debug.isOn(level) && msg != null) {
            if (params.length > 0) {
                msg = String.format(msg, params);
            }
            LEVEL_LOGS[level].log(Debug.getLogger(module), msg, t);
        }
    }

    public static boolean isOn(int level) {
        return LEVEL_ON_CACHE[level];
    }

    public static void log(String msg) {
        Debug.log(0, null, msg, NO_MODULE);
    }

    public static void log(String msg, String module) {
        Debug.log(0, null, msg, module);
    }

    public static void log(Throwable t) {
        Debug.log(0, t, null, NO_MODULE);
    }

    public static void log(Throwable t, String msg) {
        Debug.log(0, t, msg, NO_MODULE);
    }

    public static void log(Throwable t, String msg, String module) {
        Debug.log(0, t, msg, module);
    }

    public static boolean verboseOn() {
        return Debug.isOn(1);
    }

    public static void logVerbose(String msg) {
        Debug.log(1, null, msg, NO_MODULE);
    }

    public static void logVerbose(String msg, String module) {
        Debug.log(1, null, msg, module);
    }

    public static void logVerbose(Throwable t) {
        Debug.log(1, t, null, NO_MODULE);
    }

    public static void logVerbose(Throwable t, String msg) {
        Debug.log(1, t, msg, NO_MODULE);
    }

    public static void logVerbose(Throwable t, String msg, String module) {
        Debug.log(1, t, msg, module);
    }

    public static boolean timingOn() {
        return Debug.isOn(2);
    }

    public static void logTiming(String msg) {
        Debug.log(2, null, msg, NO_MODULE);
    }

    public static void logTiming(String msg, String module) {
        Debug.log(2, null, msg, module);
    }

    public static void logTiming(Throwable t) {
        Debug.log(2, t, null, NO_MODULE);
    }

    public static void logTiming(Throwable t, String msg) {
        Debug.log(2, t, msg, NO_MODULE);
    }

    public static void logTiming(Throwable t, String msg, String module) {
        Debug.log(2, t, msg, module);
    }

    public static boolean infoOn() {
        return Debug.isOn(3);
    }

    public static void logInfo(String msg) {
        Debug.log(3, null, msg, NO_MODULE);
    }

    public static void logInfo(String msg, String module) {
        Debug.log(3, null, msg, module);
    }

    public static void logInfo(Throwable t) {
        Debug.log(3, t, null, NO_MODULE);
    }

    public static void logInfo(Throwable t, String msg) {
        Debug.log(3, t, msg, NO_MODULE);
    }

    public static void logInfo(Throwable t, String msg, String module) {
        Debug.log(3, t, msg, module);
    }

    public static boolean importantOn() {
        return Debug.isOn(4);
    }

    public static void logImportant(String msg) {
        Debug.log(4, null, msg, NO_MODULE);
    }

    public static void logImportant(String msg, String module) {
        Debug.log(4, null, msg, module);
    }

    public static void logImportant(Throwable t) {
        Debug.log(4, t, null, NO_MODULE);
    }

    public static void logImportant(Throwable t, String msg) {
        Debug.log(4, t, msg, NO_MODULE);
    }

    public static void logImportant(Throwable t, String msg, String module) {
        Debug.log(4, t, msg, module);
    }

    public static boolean warningOn() {
        return Debug.isOn(5);
    }

    public static void logWarning(String msg) {
        Debug.log(5, null, msg, NO_MODULE);
    }

    public static void logWarning(String msg, String module) {
        Debug.log(5, null, msg, module);
    }

    public static void logWarning(Throwable t) {
        Debug.log(5, t, null, NO_MODULE);
    }

    public static void logWarning(Throwable t, String msg) {
        Debug.log(5, t, msg, NO_MODULE);
    }

    public static void logWarning(Throwable t, String msg, String module) {
        Debug.log(5, t, msg, module);
    }

    public static boolean errorOn() {
        return Debug.isOn(6);
    }

    public static void logError(String msg) {
        Debug.log(6, null, msg, NO_MODULE);
    }

    public static void logError(String msg, String module) {
        Debug.log(6, null, msg, module);
    }

    public static void logError(Throwable t) {
        Debug.log(6, t, null, NO_MODULE);
    }

    public static void logError(Throwable t, String msg) {
        Debug.log(6, t, msg, NO_MODULE);
    }

    public static void logError(Throwable t, String msg, String module) {
        Debug.log(6, t, msg, module);
    }

    public static boolean fatalOn() {
        return Debug.isOn(7);
    }

    public static void logFatal(String msg) {
        Debug.log(7, null, msg, NO_MODULE);
    }

    public static void logFatal(String msg, String module) {
        Debug.log(7, null, msg, module);
    }

    public static void logFatal(Throwable t) {
        Debug.log(7, t, null, NO_MODULE);
    }

    public static void logFatal(Throwable t, String msg) {
        Debug.log(7, t, msg, NO_MODULE);
    }

    public static void logFatal(Throwable t, String msg, String module) {
        Debug.log(7, t, msg, module);
    }

    public static void set(int level, boolean on) {
        Debug.LEVEL_ON_CACHE[level] = on;
    }

    static {
        LEVEL_STRING_MAP.put("verbose", 1);
        LEVEL_STRING_MAP.put("timing", 2);
        LEVEL_STRING_MAP.put("info", 3);
        LEVEL_STRING_MAP.put("important", 4);
        LEVEL_STRING_MAP.put("warning", 5);
        LEVEL_STRING_MAP.put("error", 6);
        LEVEL_STRING_MAP.put("fatal", 7);
        LEVEL_STRING_MAP.put("always", 0);
        FlexibleProperties properties = FlexibleProperties.makeFlexibleProperties(UtilURL.fromResource("debug"));
        for (int i = 0; i < LEVEL_ON_CACHE.length; ++i) {
            Debug.LEVEL_ON_CACHE[i] = i == 0 || "true".equalsIgnoreCase(properties.getProperty(LEVEL_PROPS[i]));
        }
    }

    private static interface MessageLogger {
        public void log(Logger var1, String var2, Throwable var3);
    }
}

