/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;
import org.ofbiz.core.util.UtilURL;

public class ClasspathLoader
extends ResourceLoader {
    @Override
    public InputStream loadResource(String location) throws GenericConfigException {
        String fullLocation = this.fullLocation(location);
        URL url = UtilURL.fromResource(fullLocation);
        if (url == null) {
            throw new GenericConfigException("Classpath Resource not found: " + fullLocation);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new GenericConfigException("Error opening classpath resource at location [" + url.toExternalForm() + "]", e);
        }
    }
}

