/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;

public class UtilCache {
    public static Map utilCacheTable = new HashMap();
    protected static Map defaultIndices = new HashMap();
    protected String name;
    public LinkedList keyLRUList = new LinkedList();
    public Map cacheLineTable = new HashMap();
    protected long hitCount = 0L;
    protected long missCount = 0L;
    protected long maxSize = 0L;
    protected long expireTime = 0L;
    protected boolean useSoftReference = false;

    public UtilCache(String cacheName, long maxSize, long expireTime, boolean useSoftReference) {
        this.useSoftReference = useSoftReference;
        this.maxSize = maxSize;
        this.expireTime = expireTime;
        this.setPropertiesParams(cacheName);
        this.name = cacheName + this.getNextDefaultIndex(cacheName);
        utilCacheTable.put(this.name, this);
    }

    public UtilCache(String cacheName, long maxSize, long expireTime) {
        this(cacheName, maxSize, expireTime, false);
    }

    public UtilCache(long maxSize, long expireTime) {
        this.useSoftReference = false;
        this.maxSize = maxSize;
        this.expireTime = expireTime;
        String name = "specified" + this.getNextDefaultIndex("specified");
        this.setPropertiesParams(name);
        utilCacheTable.put(name, this);
    }

    public UtilCache(String cacheName) {
        this.setPropertiesParams("default");
        this.setPropertiesParams(cacheName);
        this.name = cacheName + this.getNextDefaultIndex(cacheName);
        utilCacheTable.put(this.name, this);
    }

    public UtilCache() {
        this.setPropertiesParams("default");
        this.name = "default" + this.getNextDefaultIndex("default");
        utilCacheTable.put(this.name, this);
    }

    protected String getNextDefaultIndex(String cacheName) {
        Integer curInd = (Integer)defaultIndices.get(cacheName);
        if (curInd == null) {
            defaultIndices.put(cacheName, new Integer(1));
            return "";
        }
        defaultIndices.put(cacheName, new Integer(curInd + 1));
        return Integer.toString(curInd + 1);
    }

    protected void setPropertiesParams(String cacheName) {
        ResourceBundle res = ResourceBundle.getBundle("cache");
        if (res != null) {
            Long longValue;
            String value;
            try {
                value = res.getString(cacheName + ".maxSize");
                longValue = new Long(value);
                if (longValue != null) {
                    this.maxSize = longValue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                value = res.getString(cacheName + ".expireTime");
                longValue = new Long(value);
                if (longValue != null) {
                    this.expireTime = longValue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                value = res.getString(cacheName + ".useSoftReference");
                if (value != null) {
                    this.useSoftReference = "true".equals(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void put(Object key, Object value) {
        if (key == null) {
            return;
        }
        if (this.maxSize > 0L) {
            if (this.cacheLineTable.containsKey(key)) {
                this.keyLRUList.remove(key);
                this.keyLRUList.addFirst(key);
            } else {
                this.keyLRUList.addFirst(key);
            }
        }
        if (this.expireTime > 0L) {
            this.cacheLineTable.put(key, new CacheLine(value, this.useSoftReference, System.currentTimeMillis()));
        } else {
            this.cacheLineTable.put(key, new CacheLine(value, this.useSoftReference));
        }
        if (this.maxSize > 0L && (long)this.cacheLineTable.size() > this.maxSize) {
            Object lastKey = this.keyLRUList.getLast();
            this.remove(lastKey);
        }
    }

    public Object get(Object key) {
        if (key == null) {
            ++this.missCount;
            return null;
        }
        CacheLine line = (CacheLine)this.cacheLineTable.get(key);
        if (this.hasExpired(line)) {
            this.remove(key);
            line = null;
        }
        if (line == null) {
            ++this.missCount;
            return null;
        }
        ++this.hitCount;
        if (this.maxSize > 0L) {
            this.keyLRUList.remove(key);
            this.keyLRUList.addFirst(key);
        }
        return line.getValue();
    }

    public synchronized Object remove(Object key) {
        if (key == null) {
            ++this.missCount;
            return null;
        }
        CacheLine line = (CacheLine)this.cacheLineTable.remove(key);
        if (line != null) {
            if (this.maxSize > 0L) {
                this.keyLRUList.remove(key);
            }
            return line.getValue();
        }
        ++this.missCount;
        return null;
    }

    public synchronized void clear() {
        this.cacheLineTable.clear();
        this.keyLRUList.clear();
        this.clearCounters();
    }

    public static void clearAllCaches() {
        for (Map.Entry entry : utilCacheTable.entrySet()) {
            UtilCache utilCache = (UtilCache)entry.getValue();
            utilCache.clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public void clearCounters() {
        this.hitCount = 0L;
        this.missCount = 0L;
    }

    public void setMaxSize(long maxSize) {
        if (maxSize <= 0L) {
            this.keyLRUList.clear();
        } else if (maxSize > 0L && this.maxSize <= 0L) {
            Iterator keys = this.cacheLineTable.keySet().iterator();
            while (keys.hasNext()) {
                this.keyLRUList.add(keys.next());
            }
        }
        if (maxSize > 0L && (long)this.cacheLineTable.size() > maxSize) {
            while ((long)this.cacheLineTable.size() > maxSize) {
                Object lastKey = this.keyLRUList.getLast();
                this.remove(lastKey);
            }
        }
        this.maxSize = maxSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setExpireTime(long expireTime) {
        if (this.expireTime <= 0L && expireTime > 0L) {
            long currentTime = System.currentTimeMillis();
            for (CacheLine line : this.cacheLineTable.values()) {
                line.loadTime = currentTime;
            }
        } else if (this.expireTime > 0L || expireTime > 0L) {
            // empty if block
        }
        this.expireTime = expireTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setUseSoftReference(boolean useSoftReference) {
        if (this.useSoftReference != useSoftReference) {
            this.useSoftReference = useSoftReference;
            for (CacheLine line : this.cacheLineTable.values()) {
                line.setUseSoftReference(useSoftReference);
            }
        }
    }

    public boolean getUseSoftReference() {
        return this.useSoftReference;
    }

    public long size() {
        return this.cacheLineTable.size();
    }

    public boolean containsKey(Object key) {
        CacheLine line = (CacheLine)this.cacheLineTable.get(key);
        if (this.hasExpired(line)) {
            this.remove(key);
            line = null;
        }
        return line != null;
    }

    public boolean hasExpired(Object key) {
        if (key == null) {
            return false;
        }
        CacheLine line = (CacheLine)this.cacheLineTable.get(key);
        return this.hasExpired(line);
    }

    protected boolean hasExpired(CacheLine line) {
        if (line == null) {
            return false;
        }
        if (this.useSoftReference && line.getValue() == null) {
            return true;
        }
        if (this.expireTime <= 0L) {
            return false;
        }
        if (line.loadTime <= 0L) {
            return true;
        }
        return line.loadTime + this.expireTime < System.currentTimeMillis();
    }

    public void clearExpired() {
        for (Object key : this.cacheLineTable.keySet()) {
            if (!this.hasExpired(key)) continue;
            this.remove(key);
        }
    }

    public static void clearExpiredFromAllCaches() {
        for (Map.Entry entry : utilCacheTable.entrySet()) {
            UtilCache utilCache = (UtilCache)entry.getValue();
            utilCache.clearExpired();
        }
    }

    public static boolean validKey(String cacheName, Object key) {
        UtilCache cache = (UtilCache)utilCacheTable.get(cacheName);
        return cache != null && cache.containsKey(key);
    }

    public static class CacheLine {
        public Object valueRef = null;
        public long loadTime = 0L;
        public boolean useSoftReference = false;

        public CacheLine(Object value, boolean useSoftReference) {
            this.valueRef = useSoftReference ? new SoftReference<Object>(value) : value;
            this.useSoftReference = useSoftReference;
        }

        public CacheLine(Object value, boolean useSoftReference, long loadTime) {
            this(value, useSoftReference);
            this.loadTime = loadTime;
        }

        public Object getValue() {
            if (this.valueRef == null) {
                return null;
            }
            if (this.useSoftReference) {
                return ((SoftReference)this.valueRef).get();
            }
            return this.valueRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUseSoftReference(boolean useSoftReference) {
            if (this.useSoftReference != useSoftReference) {
                CacheLine cacheLine = this;
                synchronized (cacheLine) {
                    this.useSoftReference = useSoftReference;
                    this.valueRef = useSoftReference ? new SoftReference<Object>(this.valueRef) : ((SoftReference)this.valueRef).get();
                }
            }
        }
    }
}

