package com.atlassian.oauth2.provider.api.token.access;

import com.atlassian.oauth2.scopes.api.Scope;

import javax.annotation.Nonnull;

public interface AccessToken {

    @Nonnull
    String getId();

    @Nonnull
    String getClientId();

    @Nonnull
    String getUserKey();

    @Nonnull
    String getAuthorizationCode();

    @Nonnull
    Long getAuthorizationDate();

    @Nonnull
    Long getCreatedAt();

    Long getLastAccessed();

    @Nonnull
    Scope getScope();
}
