package com.atlassian.oauth2.provider.api.token;

import com.atlassian.oauth2.provider.api.token.exception.access.AccessFailedException;
import com.atlassian.oauth2.provider.api.token.exception.access.ExpiredTokenException;
import com.atlassian.oauth2.provider.api.token.exception.access.UnrecognisedTokenException;
import com.atlassian.oauth2.provider.api.token.exception.access.UnrecognisedUserKeyException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Provides operations to authenticate with Atlassian products through access tokens
 */
public interface AccessTokenAuthenticationHandler {

    /**
     * Authenticates a HTTP request using the access token defined in the Authorization header.
     * See https://tools.ietf.org/html/rfc6749#section-7
     *
     * @param request the request
     * @param response the response
     * @param bearerToken the bearer token provided with the request
     * @throws UnrecognisedTokenException when the token is unrecognised
     * @throws ExpiredTokenException when the token has expired
     * @throws UnrecognisedUserKeyException when the user key associated with the token is unrecognised
     */
    AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, String bearerToken) throws AccessFailedException;
}
