package com.atlassian.oauth2.provider.api.pkce;

/**
 * Determines how the PKCE code verifier should be transformed and validated when exchanging
 * an authorization code for access/refresh tokens.
 *
 * https://datatracker.ietf.org/doc/html/rfc7636#section-4.3
 */
public enum CodeChallengeMethod {

    PLAIN("plain"),
    S256("S256");

    private final String method;

    CodeChallengeMethod(final String method) {
        this.method = method;
    }

    public static CodeChallengeMethod fromString(final String codeChallengeMethodString) {
        if (codeChallengeMethodString == null) {
            return null;
        }
        try {
            return CodeChallengeMethod.valueOf(codeChallengeMethodString.toUpperCase());
        } catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return method;
    }
}
