package com.atlassian.oauth2.provider.api.client.dao;

import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.scopes.api.Scope;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;

@ToString
@Getter
@Builder(toBuilder = true)
@EqualsAndHashCode
@AllArgsConstructor
public class ClientEntity implements Client {
    @Nonnull
    private final String id;
    @NonNull
    private final String clientId;
    @NonNull
    private final String clientSecret;
    @NonNull
    private final String name;
    private final List<String> redirects;
    @NonNull
    private final String userKey;
    @NonNull
    private final Scope scope;

    @Override
    @Nonnull
    public List<String> getRedirects() {
        return redirects != null ? redirects : Collections.emptyList();
    }
}
