package com.atlassian.oauth2.provider.api.authorization.dao;

import com.atlassian.oauth2.provider.api.authorization.Authorization;
import com.atlassian.oauth2.provider.api.pkce.CodeChallengeMethod;
import com.atlassian.oauth2.scopes.api.Scope;
import lombok.Builder;
import lombok.Data;
import lombok.NonNull;

@Data
@Builder(toBuilder = true)
public class AuthorizationEntity implements Authorization {
    @NonNull
    private final String authorizationCode;
    @NonNull
    private final String clientId;
    @NonNull
    private final String redirectUri;
    @NonNull
    private final String userKey;
    @NonNull
    private final Long createdAt;
    @NonNull
    private final Scope scope;

    private final CodeChallengeMethod codeChallengeMethod;
    private final String codeChallenge;
}
