package com.atlassian.oauth2.provider.api.authorization.dao;

import com.atlassian.oauth2.provider.api.authorization.Authorization;

import java.time.Duration;
import java.util.Optional;

public interface AuthorizationDao {

    Authorization save(Authorization authorization);

    Optional<Authorization> removeByCode(String authorizationCode);

    Optional<Authorization> findByCode(String authorizationCode);

    void removeExpiredAuthorizationsAfter(Duration expirationPeriod);
}
