package com.atlassian.oauth2.provider.api.authorization;

/**
 * https://tools.ietf.org/html/rfc6749#section-5.2
 * High level errors
 */
public enum TokenResponseError {
    INVALID_CLIENT("invalid_client"),
    INVALID_GRANT("invalid_grant"),
    INVALID_REQUEST("invalid_request"),
    UNSUPPORTED_RESPONSE_TYPE("unsupported_response_type");

    public final String name;

    TokenResponseError(final String name) {
        this.name = name;
    }
}
