package com.atlassian.oauth2.provider.api.authorization;

import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.function.Consumer;
import java.util.function.Function;

@EqualsAndHashCode
@ToString
public class AuthorizationFlowResult {

    private final Authorization authorization;
    private final TokenResponseErrorDescription errorReason;

    public static AuthorizationFlowResult success(final Authorization authorization) {
        return new AuthorizationFlowResult(authorization, null);
    }

    public static AuthorizationFlowResult failed(final TokenResponseErrorDescription errorReason) {
        return new AuthorizationFlowResult(null, errorReason);
    }

    private AuthorizationFlowResult(final Authorization authorization,
                                    final TokenResponseErrorDescription errorReason) {
        this.authorization = authorization;
        this.errorReason = errorReason;
    }

    public <T> T fold(final Function<Authorization, T> ifSuccess, final Function<TokenResponseErrorDescription, T> ifFailure) {
        if (authorization == null) {
            return ifFailure.apply(errorReason);
        } else {
            return ifSuccess.apply(authorization);
        }
    }

    public void ifSuccess(final Consumer<Authorization> ifSuccess) {
        if (authorization == null) {
            return;
        }
        ifSuccess.accept(authorization);
    }

    public void ifFailure(final Consumer<TokenResponseErrorDescription> ifFailure) {
        if (errorReason == null) {
            return;
        }
        ifFailure.accept(errorReason);
    }
}
