package com.atlassian.oauth2.provider.api.authorization;

import com.atlassian.oauth2.provider.api.pkce.CodeChallengeMethod;
import com.atlassian.oauth2.scopes.api.Scope;

import javax.annotation.Nonnull;

public interface Authorization {

    @Nonnull
    String getAuthorizationCode();

    @Nonnull
    String getClientId();

    @Nonnull
    String getRedirectUri();

    @Nonnull
    String getUserKey();

    @Nonnull
    Long getCreatedAt();

    @Nonnull
    Scope getScope();

    CodeChallengeMethod getCodeChallengeMethod();

    String getCodeChallenge();
}
