/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.api.token;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;

public enum FlowType {
    PKCE("pkce"),
    AUTHORIZATION_CODE("authorization_code");

    final String flowIdentifier;
    public static final Set<FlowType> PUBLIC_FLOWS;

    private FlowType(String flowType) {
        this.flowIdentifier = flowType;
    }

    public static FlowType fromIdentifier(@Nullable String identifier) {
        return Arrays.stream(FlowType.values()).filter(flowType -> flowType.flowIdentifier.equals(identifier)).findFirst().orElse(AUTHORIZATION_CODE);
    }

    public String getFlowIdentifier() {
        return this.flowIdentifier;
    }

    static {
        PUBLIC_FLOWS = Collections.unmodifiableSet(EnumSet.of(PKCE));
    }
}

