/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.jobs;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.api.storage.event.ClientTokenDeletedEvent;
import com.atlassian.oauth2.client.storage.token.dao.ClientTokenStore;
import com.atlassian.oauth2.client.util.properties.SystemProperty;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Clock;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TokenPruningJob
implements JobRunner,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TokenPruningJob.class);
    private static final JobId JOB_ID = JobId.of((String)TokenPruningJob.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)TokenPruningJob.class.getSimpleName());
    private final SchedulerService schedulerService;
    private final ClientTokenStore clientTokenStore;
    private final Clock clock;
    private final EventPublisher eventPublisher;

    public TokenPruningJob(SchedulerService schedulerService, ClientTokenStore clientTokenStore, Clock clock, EventPublisher eventPublisher) {
        this.schedulerService = schedulerService;
        this.clientTokenStore = clientTokenStore;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        String pruneExpiredTokensSchedule = SystemProperty.PRUNE_EXPIRED_TOKENS_SCHEDULE.getValue();
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(Schedule.forCronExpression((String)pruneExpiredTokensSchedule)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
        logger.info("Registered expired tokens pruning job with schedule " + pruneExpiredTokensSchedule);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        logger.info("Pruning expired OAuth 2.0 tokens");
        List<String> removedExpiredTokens = this.clientTokenStore.deleteTokensExpiringBefore(this.clock.instant().minus(SystemProperty.MAX_CLOCK_SKEW.getValue()));
        List<String> removedInvalidTokens = this.clientTokenStore.deleteTokensUnrecoverableSince(this.clock.instant().minus(SystemProperty.LIFETIME_OF_INVALID_TOKEN.getValue()));
        Stream.concat(removedExpiredTokens.stream(), removedInvalidTokens.stream()).forEach(tokenId -> this.eventPublisher.publish((Object)new ClientTokenDeletedEvent(tokenId)));
        logger.info("Number of removed expired tokens {} and number of removed invalid tokens {}", (Object)removedExpiredTokens.size(), (Object)removedInvalidTokens.size());
        return JobRunnerResponse.success();
    }

    public void destroy() throws Exception {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        logger.debug("Unregistered expired tokens pruning job.");
    }
}

