/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.util.properties;

import com.atlassian.oauth2.client.util.properties.AbstractSystemProperty;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationSystemProperty
extends AbstractSystemProperty<Duration> {
    private static final Logger logger = LoggerFactory.getLogger(DurationSystemProperty.class);
    private final TemporalUnit temporalUnit;

    DurationSystemProperty(@Nonnull String propertyName, @Nonnull TemporalUnit temporalUnit, long defaultValue) {
        super(propertyName, Duration.of(defaultValue, temporalUnit));
        this.temporalUnit = temporalUnit;
    }

    @Override
    @Nonnull
    public Duration getValue() {
        String rawValue = System.getProperty(this.propertyName);
        try {
            return Optional.ofNullable(rawValue).map(Long::parseLong).map(value -> Duration.of(value, this.temporalUnit)).orElse((Duration)this.defaultValue);
        }
        catch (NumberFormatException e) {
            logger.warn("Illegal value of system property " + this.propertyName + ", expected a long integer but was: " + rawValue);
            return (Duration)this.defaultValue;
        }
    }

    @Override
    public void setValue(@Nonnull Duration value) {
        System.setProperty(this.propertyName, String.valueOf(value.toNanos() / this.temporalUnit.getDuration().toNanos()));
    }
}

