/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.util;

import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.util.properties.SystemProperty;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class HttpsValidator {
    private final ApplicationProperties applicationProperties;

    public HttpsValidator(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public boolean isSecure(String uri) {
        try {
            return StringUtils.isNotBlank((CharSequence)uri) && this.isSecure(new URL(uri));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean isSecure(URI uri) {
        return !this.isOAuthProviderUrlHttpsRequired() || this.isHttps(uri);
    }

    public boolean isSecure(URL url) {
        return !this.isOAuthProviderUrlHttpsRequired() || this.isHttps(url);
    }

    public boolean isHttps(String uri) {
        return StringUtils.isNotBlank((CharSequence)uri) && this.isHttps(URI.create(uri));
    }

    public boolean isHttps(URI uri) {
        return this.isHttpsProtocol(uri.getScheme());
    }

    public boolean isHttps(URL url) {
        return this.isHttpsProtocol(url.getProtocol());
    }

    public boolean isOAuthProviderUrlHttpsRequired() {
        return SystemProperty.DEV_MODE.getValue() == false && SystemProperty.SKIP_PROVIDER_HTTPS_REQUIREMENT.getValue() == false;
    }

    public boolean isBaseUrlHttpsRequired() {
        return SystemProperty.DEV_MODE.getValue() == false && SystemProperty.SKIP_BASE_URL_HTTPS_REQUIREMENT.getValue() == false;
    }

    public boolean isBaseUrlHttps() {
        return this.isHttps(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL));
    }

    private boolean isHttpsProtocol(String protocol) {
        return "https".equals(protocol);
    }

    public void assertSecure(ClientConfiguration clientConfiguration) {
        Preconditions.checkArgument((boolean)this.isSecure(clientConfiguration.getAuthorizationEndpoint()), (Object)"Authorization endpoint not https");
        Preconditions.checkArgument((boolean)this.isSecure(clientConfiguration.getTokenEndpoint()), (Object)"Token endpoint not https");
    }

    public void assertBaseUrlSecure(URI baseUrl) {
        Preconditions.checkState((!this.isBaseUrlHttpsRequired() || this.isHttps(baseUrl) ? 1 : 0) != 0, (Object)"Base url protocol needs to be https");
    }
}

