/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.api.storage.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Optional;

public enum GrantType {
    AUTHORIZATION_CODE_GRANT("authorization_code", true),
    CLIENT_CREDENTIALS_GRANT("client_credentials", false);

    private final String name;
    private final boolean requiresAuthorization;

    private GrantType(String name, boolean requiresAuthorization) {
        this.name = name;
        this.requiresAuthorization = requiresAuthorization;
    }

    @JsonCreator
    public static GrantType forValue(String value) {
        return GrantType.getByName(value).orElse(null);
    }

    public static GrantType defaultGrantType() {
        return AUTHORIZATION_CODE_GRANT;
    }

    public static Optional<GrantType> getByName(String name) {
        return Arrays.stream(GrantType.values()).filter(type -> type.name.equalsIgnoreCase(name)).findAny();
    }

    public static GrantType getByNameOrDefault(String name) {
        return GrantType.getByName(name).orElse(GrantType.defaultGrantType());
    }

    public static GrantType orDefaultGrantType(GrantType grantType) {
        return Optional.ofNullable(grantType).orElse(GrantType.defaultGrantType());
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public boolean requiresAuthorization() {
        return this.requiresAuthorization;
    }
}

