package com.atlassian.oauth2.client.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.Instant;

/**
 * The result of the OAuth 2 flow containing the accessToken and refreshToken
 */
public interface ClientToken {
    @Nonnull
    String getAccessToken();

    @Nonnull
    Instant getAccessTokenExpiration();

    @Nullable
    String getRefreshToken();

    @Nullable
    Instant getRefreshTokenExpiration();
}
