package com.atlassian.oauth2.client.api.storage.token.exception;

import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;

import javax.annotation.Nonnull;

/**
 * Indicates that a {@link ClientConfigurationEntity} can't be found in the database.
 */
public class ConfigurationNotFoundException extends UnrecoverableTokenException {
    public ConfigurationNotFoundException(@Nonnull final String message) {
        super(message);
    }

    public ConfigurationNotFoundException(@Nonnull final String message, @Nonnull final Throwable cause) {
        super(message, cause);
    }
}
