package com.atlassian.oauth2.client.api.storage.event;

import java.util.Objects;

import com.atlassian.analytics.api.annotations.EventName;

@EventName("plugins.oauth2.client.token.recoverable")
public class ClientTokenRecoverableEvent implements ClientTokenEvent {

    private final String clientTokenId;

    public ClientTokenRecoverableEvent(final String clientTokenId) {
        this.clientTokenId = clientTokenId;
    }

    @Override
    public String getClientTokenId() {
        return clientTokenId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ClientTokenRecoverableEvent that = (ClientTokenRecoverableEvent) o;
        return Objects.equals(clientTokenId, that.clientTokenId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientTokenId);
    }
}
