package com.atlassian.oauth2.client.api.storage.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.token.deleted")
public class ClientTokenDeletedEvent implements ClientTokenEvent {

    private final String clientTokenId;

    public ClientTokenDeletedEvent(final String clientTokenId) {
        this.clientTokenId = clientTokenId;
    }

    @Override
    public String getClientTokenId() {
        return clientTokenId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ClientTokenDeletedEvent that = (ClientTokenDeletedEvent) o;
        return Objects.equals(clientTokenId, that.clientTokenId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientTokenId);
    }
}
