package com.atlassian.oauth2.client.api.storage.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.configuration.deleted")
public class ClientConfigurationDeletedEvent {

    private final String clientConfigurationId;

    public ClientConfigurationDeletedEvent(final String clientConfigurationId) {
        this.clientConfigurationId = clientConfigurationId;
    }

    public String getClientConfigurationId() {
        return clientConfigurationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ClientConfigurationDeletedEvent that = (ClientConfigurationDeletedEvent) o;
        return Objects.equals(clientConfigurationId, that.clientConfigurationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientConfigurationId);
    }
}
