package com.atlassian.oauth2.client.api.storage.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.configuration.created")
public class ClientConfigurationCreatedEvent {

    private final String clientConfigurationId;

    public ClientConfigurationCreatedEvent(final String clientConfigurationId) {
        this.clientConfigurationId = clientConfigurationId;
    }

    public String getClientConfigurationId() {
        return clientConfigurationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ClientConfigurationCreatedEvent that = (ClientConfigurationCreatedEvent) o;
        return Objects.equals(clientConfigurationId, that.clientConfigurationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientConfigurationId);
    }
}
