package com.atlassian.oauth2.client.api.lib.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.flow.request.completed.unsuccessfully")
public class FlowRequestUnsuccessfullyCompletedEvent extends FlowRequestCompletedEvent {

    private final String errorMessage;

    public FlowRequestUnsuccessfullyCompletedEvent(final String flowRequestId,
                                                   final String clientId,
                                                   final String providerType,
                                                   final String errorMessage) {
        super(flowRequestId, clientId, providerType);
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final FlowRequestUnsuccessfullyCompletedEvent that = (FlowRequestUnsuccessfullyCompletedEvent) o;
        return Objects.equals(getFlowRequestId(), that.getFlowRequestId()) &&
                Objects.equals(getClientId(), that.getClientId()) &&
                Objects.equals(getProviderType(), that.getProviderType()) &&
                Objects.equals(getErrorMessage(), that.getErrorMessage());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getFlowRequestId(), getClientId(), getProviderType(), getErrorMessage());
    }
}
