/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.accesstoken;

import com.atlassian.oauth2.accesstoken.ConstraintViolationImpl;
import com.atlassian.oauth2.accesstoken.SessionClaimSet;
import com.google.common.collect.ImmutableSet;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.Valid;

public class ConnectSessionAuthToken {
    private static final int MIN_RESOURCE_SERVERS = 1;
    private static final int MAX_RESOURCE_SERVERS = 200;
    private static final int MIN_SCOPES = 1;
    private static final int MAX_SCOPES = 200;
    private static final int MIN_TYP_LENGTH = 1;
    private static final int MAX_TYP_LENGTH = 200;
    private final SignedJWT jwt;

    private ConnectSessionAuthToken(@Nonnull SignedJWT jwt) {
        this.jwt = jwt;
    }

    public ConnectSessionAuthToken(@Nonnull SessionClaimSet sessionClaimSet, @Nonnull RSAPrivateKey privateKey, @Nonnull String keyId) throws JOSEException {
        this(ConnectSessionAuthToken.createAndSign(sessionClaimSet, privateKey, keyId));
    }

    private static SignedJWT createAndSign(@Nonnull SessionClaimSet sessionClaimSet, @Nonnull RSAPrivateKey privateKey, @Nonnull String keyId) throws JOSEException {
        SignedJWT jwt = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(keyId).build(), sessionClaimSet.jwtClaimSet());
        jwt.sign((JWSSigner)new RSASSASigner((PrivateKey)privateKey));
        return jwt;
    }

    public static Optional<ConnectSessionAuthToken> parse(@Nonnull String jwtString) throws ParseException {
        ConnectSessionAuthToken authToken = new ConnectSessionAuthToken(SignedJWT.parse((String)jwtString));
        return authToken.getSessionClaimSet().map(claimSet -> authToken);
    }

    @Valid
    public Optional<SessionClaimSet> getSessionClaimSet() throws ParseException {
        return SessionClaimSet.from(this.jwt.getJWTClaimsSet());
    }

    public String serialize() {
        return this.jwt.serialize();
    }

    public boolean verify(@Nonnull RSAPublicKey publicKey) throws JOSEException {
        return this.jwt.verify((JWSVerifier)new RSASSAVerifier(publicKey));
    }

    public String keyId() {
        return this.jwt.getHeader().getKeyID();
    }

    public Set<ConstraintViolation<ConnectSessionAuthToken>> validate() throws ParseException {
        if (!this.getSessionClaimSet().isPresent()) {
            return ImmutableSet.of((Object)new ConstraintViolationImpl("Missing claimsSet", "claimSet"));
        }
        SessionClaimSet claimSet = this.getSessionClaimSet().get();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getAuthorizationServerId(), "authorizationServerId");
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getCoatVersion(), "coatVersion");
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getImpersonatedUserId(), "impersonatedUserId");
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getOauthClientId(), "oauthClientId");
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getJWTID(), "jwtId");
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getResourceServerUrls(), "resourceServerUrls");
        ConnectSessionAuthToken.checkCollectionLength((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getResourceServerUrls(), "resourceServerUrls", 1, 200);
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getScopes(), "scopes");
        ConnectSessionAuthToken.checkCollectionLength((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getScopes(), "scopes", 1, 200);
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getTyp(), "typ");
        ConnectSessionAuthToken.checkStringLength((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getTyp(), "typ", 1, 200);
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getIssueTime(), "issueTime");
        ConnectSessionAuthToken.checkNotNull((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getExpirationTime(), "expirationTime");
        ConnectSessionAuthToken.checkInFuture((ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>>)builder, claimSet.getExpirationTime(), "expirationTime");
        return builder.build();
    }

    private static void checkNotNull(ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>> builder, Object value, String name) {
        if (value == null) {
            builder.add((Object)new ConstraintViolationImpl("may not be null", "sessionClaimSet." + name));
        }
    }

    private static void checkInFuture(ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>> builder, Date value, String name) {
        Date now;
        if (value != null && !value.after(now = new Date())) {
            builder.add((Object)new ConstraintViolationImpl("must be in the future", "sessionClaimSet." + name));
        }
    }

    private static void checkStringLength(ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>> builder, String value, String name, int min, int max) {
        if (value != null && (value.length() < min || value.length() > max)) {
            builder.add((Object)new ConstraintViolationImpl(name + " must be between " + min + " and " + max + " characters long", "sessionClaimSet." + name));
        }
    }

    private static void checkCollectionLength(ImmutableSet.Builder<ConstraintViolation<ConnectSessionAuthToken>> builder, Collection<?> value, String name, int min, int max) {
        if (value != null && (value.size() < min || value.size() > max)) {
            builder.add((Object)new ConstraintViolationImpl("size must be between " + min + " and " + max, "sessionClaimSet." + name));
        }
    }

    public static interface ConstraintViolation<T> {
        public String getMessage();

        public String getPropertyPath();
    }
}

