package com.atlassian.oauth.shared.servlet;

import java.io.Serializable;

import com.atlassian.sal.api.message.I18nResolver;

import static com.google.common.base.Preconditions.checkNotNull;

public final class Message
{
    private final String key;
    private final Serializable[] params;
    private final I18nResolver resolver;

    public Message(I18nResolver resolver, String key, Serializable[] params)
    {
        this.resolver = checkNotNull(resolver, "resolver");
        this.key = checkNotNull(key, "key");
        this.params = checkNotNull(params, "params");
    }

    @Override
    public String toString()
    {
        return resolver.getText(key, params);
    }
}
