package com.atlassian.oauth.event;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

/**
 * This is an abstract base class for token removal events.
 */
@ParametersAreNullableByDefault
public abstract class TokenRemovedEvent {
    private final String username;
    private final String consumerKey;

    protected TokenRemovedEvent(String username, String consumerKey) {
        this.username = username;
        this.consumerKey = consumerKey;
    }

    /**
     * @return name of the user the token belonged to or {@code null} if unauthorized
     */
    @Nullable
    public String getUsername() {
        return username;
    }

    /**
     * @return consumer key that this token was associated with or {@code null} if not assicated with any consumer
     */
    @Nullable
    public String getConsumerKey() {
        return consumerKey;
    }
}
