package com.atlassian.oauth.event;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

/**
 * This is an abstract base class for token addition events.
 *
 * @since 4.1
 */
@ParametersAreNullableByDefault
public abstract class TokenAddedEvent {
    private final String username;
    private final String consumerKey;

    protected TokenAddedEvent(String username, String consumerKey) {
        this.username = username;
        this.consumerKey = consumerKey;
    }

    /**
     * @return username which is associated with the token or {@code null} if unauthorized
     */
    @Nullable
    public String getUsername() {
        return username;
    }

    /**
     * @return consumer key that this token is associated with or {@code null} if not assicated with any consumer
     */
    @Nullable
    public String getConsumerKey() {
        return consumerKey;
    }
}
