package com.atlassian.oauth.event;

import javax.annotation.ParametersAreNullableByDefault;

/**
 * This event is published when a request token is removed from the service provider.
 */
@ParametersAreNullableByDefault
public class RequestTokenRemovedEvent extends TokenRemovedEvent {
    /**
     * This is for backwards compatibility.
     *
     * @deprecated use {@link #RequestTokenRemovedEvent(String, String)} instead
     */
    @Deprecated
    public RequestTokenRemovedEvent(String username) {
        this(username, null);
    }

    /**
     * @param username belonging to the user who's request token is being revoked
     * @param consumerKey the consumer key with which the token was previously associated
     */
    public RequestTokenRemovedEvent(String username, String consumerKey) {
        super(username, consumerKey);
    }
}
