/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.consumer;

import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.shared.servlet.AbstractAdminServlet;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ListServiceProvidersServlet
extends AbstractAdminServlet {
    private final ConsumerService service;
    private final TemplateRenderer renderer;

    public ListServiceProvidersServlet(ConsumerService service, TemplateRenderer renderer, UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.service = (ConsumerService)Preconditions.checkNotNull((Object)service, (Object)"service");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    protected void doRestrictedGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        Iterable consumers = this.service.getAllServiceProviders();
        this.renderer.render("service-providers/list.vm", (Map)ImmutableMap.of((Object)"consumers", (Object)consumers), (Writer)response.getWriter());
    }

    protected void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String consumerKey = request.getParameter("key");
        if (consumerKey == null) {
            response.sendError(400);
            return;
        }
        this.service.removeConsumerByKey(consumerKey);
    }
}

