/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.pact;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.MockServer;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit.PactProviderRule;
import au.com.dius.pact.consumer.junit.PactVerification;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.annotations.Pact;
import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.pact.IgnoreApiValidation;
import com.atlassian.oai.validator.pact.PactLevelResolverFactory;
import com.atlassian.oai.validator.pact.PactRequest;
import com.atlassian.oai.validator.pact.PactResponse;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ValidatedPactProviderRule
implements TestRule {
    private final PactProviderRule delegate;
    private final String providerId;
    private final Object target;
    private final OpenApiInteractionValidator validator;

    public ValidatedPactProviderRule(String specUrlOrPayload, String basePathOverride, String providerId, Object target) {
        this(specUrlOrPayload, basePathOverride, providerId, target, new PactProviderRule(providerId, target));
    }

    public ValidatedPactProviderRule(String specUrlOrPayload, String basePathOverride, String providerId, String host, Integer port, Object target) {
        this(specUrlOrPayload, basePathOverride, providerId, target, new PactProviderRule(providerId, host, port, target));
    }

    private ValidatedPactProviderRule(String specUrlOrPayload, String basePathOverride, String providerId, Object target, PactProviderRule delegate) {
        this.validator = OpenApiInteractionValidator.createFor((String)specUrlOrPayload).withLevelResolver(PactLevelResolverFactory.create()).withBasePathOverride(basePathOverride).build();
        this.providerId = providerId;
        this.target = target;
        this.delegate = delegate;
    }

    public ValidatedPactProviderRule(OpenApiInteractionValidator validator, String providerId, Object target) {
        this.validator = validator;
        this.providerId = providerId;
        this.target = target;
        this.delegate = new PactProviderRule(providerId, target);
    }

    public ValidatedPactProviderRule(OpenApiInteractionValidator validator, String providerId, String host, Integer port, Object target) {
        this.validator = validator;
        this.providerId = providerId;
        this.target = target;
        this.delegate = new PactProviderRule(providerId, host, port, target);
    }

    public MockProviderConfig getConfig() {
        return this.delegate.getConfig();
    }

    public MockServer getMockServer() {
        return this.delegate.getMockServer();
    }

    public String getUrl() {
        return this.getMockServer().getUrl();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                IgnoreApiValidation ignore = (IgnoreApiValidation)description.getAnnotation(IgnoreApiValidation.class);
                if (pactDef != null && ignore == null) {
                    ValidatedPactProviderRule.this.validatePactDef(pactDef);
                }
                ValidatedPactProviderRule.this.delegate.apply(base, description).evaluate();
            }
        };
    }

    private void validatePactDef(PactVerification pactVerification) throws Exception {
        Optional<RequestResponsePact> requestResponsePact = this.getRequestResponsePact(pactVerification);
        if (!requestResponsePact.isPresent()) {
            return;
        }
        ValidationReport report = requestResponsePact.get().getInteractions().stream().map(Interaction::asSynchronousRequestResponse).map(i -> this.validator.validate(PactRequest.of(i.getRequest()), PactResponse.of(i.getResponse()))).reduce(ValidationReport.empty(), ValidationReport::merge);
        if (report.hasErrors()) {
            throw new PactValidationError(report);
        }
    }

    private Optional<RequestResponsePact> getRequestResponsePact(PactVerification pactVerification) throws Exception {
        Optional<Method> possiblePactMethod = this.findPactMethod(pactVerification);
        if (!possiblePactMethod.isPresent()) {
            return Optional.empty();
        }
        Method method = possiblePactMethod.get();
        Pact pact = method.getAnnotation(Pact.class);
        PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pact.consumer()).hasPactWith(this.providerId);
        return Optional.of((RequestResponsePact)method.invoke(this.target, dslBuilder));
    }

    private Optional<Method> findPactMethod(PactVerification pactVerification) {
        String pactFragment = pactVerification.fragment();
        for (Method method : this.target.getClass().getMethods()) {
            boolean hasValidPactSignature;
            Pact pact = method.getAnnotation(Pact.class);
            if (pact == null || !pact.provider().equals(this.providerId) || !pactFragment.isEmpty() && !pactFragment.equals(method.getName())) continue;
            boolean bl = hasValidPactSignature = RequestResponsePact.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(PactDslWithProvider.class);
            if (!hasValidPactSignature) {
                return Optional.empty();
            }
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public static class PactValidationError
    extends RuntimeException {
        private final ValidationReport report;

        public PactValidationError(ValidationReport report) {
            super(JsonValidationReportFormat.getInstance().apply(report));
            this.report = report;
        }

        public ValidationReport getValidationReport() {
            return this.report;
        }
    }
}

